/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.tpane;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicPanelUI;
import org.openmicroscopy.shoola.agents.hiviewer.tpane.BorderListener;
import org.openmicroscopy.shoola.agents.hiviewer.tpane.TinyPane;
import org.openmicroscopy.shoola.agents.hiviewer.tpane.TitleBar;
import org.openmicroscopy.shoola.util.ui.border.FrameBorder;

class TinyPaneUI
extends BasicPanelUI
implements ComponentListener,
MouseListener,
MouseMotionListener,
PropertyChangeListener {
    public static final int BORDER_MARGIN = 2;
    public static final int BORDER_THICKNESS = 1;
    public static final int SCROLLBAR_THICKNESS = 8;
    public static final Color BORDER_COLOR = new Color(99, 130, 191);
    public static final Color INNER_BORDER_HIGHLIGHT = new Color(240, 240, 240);
    public static final Color INNER_BORDER_SHADOW = new Color(200, 200, 200);
    public static final Color DESKTOP_COLOR = new Color(250, 253, 255);
    private JScrollPane dskDecorator;
    private TinyPane frame;
    private TitleBar titleBar;
    private FrameBorder border;
    private BorderListener borderListener;

    private void attachBorderListener() {
        this.frame.addMouseListener(this);
        this.frame.addMouseMotionListener(this);
        this.titleBar.addMouseListener(this);
        this.titleBar.addMouseMotionListener(this);
    }

    private void detachBorderListener() {
        this.frame.removeMouseListener(this);
        this.frame.removeMouseMotionListener(this);
        this.titleBar.removeMouseListener(this);
        this.titleBar.removeMouseMotionListener(this);
    }

    private void updateCollapsedState() {
        if (this.frame.isCollapsed()) {
            this.frame.remove(this.frame.getContentPane());
            int h = this.titleBar.getPreferredSize().height;
            this.frame.setSize(this.frame.getWidth(), h + 6);
        } else {
            this.frame.add(this.frame.getContentPane());
            this.frame.setSize(this.frame.getRestoreSize());
            this.frame.moveToFront();
            this.frame.repaint();
        }
    }

    protected FrameBorder makeBorder() {
        return new FrameBorder(BORDER_COLOR, DESKTOP_COLOR, 2);
    }

    TinyPaneUI(TinyPane frame) {
        if (frame == null) {
            throw new NullPointerException("No frame.");
        }
        this.frame = frame;
        this.borderListener = new BorderListener(frame);
        this.titleBar = new TitleBar(frame);
        this.border = this.makeBorder();
        frame.setBorder(this.border);
        frame.setOpaque(false);
        frame.addPropertyChangeListener(this);
        frame.addComponentListener(this);
        this.attachBorderListener();
    }

    JScrollPane decorateDesktopPane(JLayeredPane dp) {
        dp.setOpaque(true);
        dp.setBackground(DESKTOP_COLOR);
        this.dskDecorator = new JScrollPane(dp);
        this.dskDecorator.setBorder(BorderFactory.createBevelBorder(1, INNER_BORDER_HIGHLIGHT, INNER_BORDER_SHADOW));
        return this.dskDecorator;
    }

    JScrollPane getDeskDecorator() {
        return this.dskDecorator;
    }

    JComponent getTitleBar() {
        return this.titleBar;
    }

    Rectangle getFrameIconBounds() {
        return this.titleBar.getFrameIconBounds();
    }

    Dimension getIdealSize() {
        Dimension sz = new Dimension();
        int h = this.titleBar.getPreferredSize().height;
        JComponent dskDecorator = this.frame.getInternalDesktop();
        Dimension internalDesktopSz = this.frame.getContentPane().getPreferredSize();
        Insets scrollPaneInsets = dskDecorator.getInsets();
        Insets frameInsets = this.frame.getInsets();
        sz.width = frameInsets.left + scrollPaneInsets.left + internalDesktopSz.width + scrollPaneInsets.right + frameInsets.right;
        sz.height = frameInsets.top + scrollPaneInsets.top + internalDesktopSz.height + scrollPaneInsets.bottom + frameInsets.bottom + h;
        return sz;
    }

    DesktopManager getDesktopManager() {
        return this.borderListener.getDesktopManager();
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String propChanged = pce.getPropertyName();
        if ("highlight".equals(propChanged)) {
            this.border.setBackgroundColor((Color)pce.getNewValue());
            this.frame.moveToFront();
        } else if ("collapsed".equals(propChanged)) {
            this.updateCollapsedState();
        } else if ("titleBarType".equals(propChanged)) {
            this.frame.setSize(this.frame.getPreferredSize());
            if (this.frame.getWidth() < 48) {
                this.frame.setSize(48, this.frame.getHeight());
            }
            this.frame.validate();
        } else if ("borderListener".equals(propChanged)) {
            boolean b = (Boolean)pce.getNewValue();
            if (b) {
                this.attachBorderListener();
            } else {
                this.detachBorderListener();
            }
        }
    }

    public void componentResized(ComponentEvent ce) {
        Rectangle b = this.frame.getContentsBounds();
        Dimension d = new Dimension(b.width, b.height);
        if (b.x < 0) {
            d.width += b.x;
        }
        if (b.y < 0) {
            d.height += b.y;
        }
        this.frame.getInternalDesktop().setPreferredSize(d);
    }

    public void componentMoved(ComponentEvent ce) {
        this.frame.repaint();
    }

    public void componentHidden(ComponentEvent ce) {
    }

    public void componentShown(ComponentEvent ce) {
    }

    public void mouseClicked(MouseEvent me) {
        this.borderListener.mouseClicked(me);
    }

    public void mousePressed(MouseEvent me) {
        this.borderListener.mousePressed(me);
    }

    public void mouseReleased(MouseEvent me) {
        this.borderListener.mouseReleased(me);
    }

    public void mouseEntered(MouseEvent me) {
        this.borderListener.mouseEntered(me);
    }

    public void mouseExited(MouseEvent me) {
        this.borderListener.mouseExited(me);
    }

    public void mouseDragged(MouseEvent me) {
        this.borderListener.mouseDragged(me);
    }

    public void mouseMoved(MouseEvent me) {
        this.borderListener.mouseMoved(me);
    }
}

