/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.saver;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import org.openmicroscopy.shoola.agents.hiviewer.layout.LayoutUtils;
import org.openmicroscopy.shoola.agents.hiviewer.saver.ContainerSaver;
import org.openmicroscopy.shoola.agents.hiviewer.saver.Preview;

class PreviewMng
implements ActionListener {
    private static final int SAVE = 0;
    private static final int PREVIEW = 1;
    private static final int CANCEL = 2;
    private static final Color DEFAULT_BG = Color.WHITE;
    private static final int DEFAULT_SPACE = 4;
    private Preview view;
    private ContainerSaver model;
    private Dimension maxDim;
    private BufferedImage image;

    private void preview() {
        int index = this.view.colors.getSelectedIndex();
        Color c = this.view.getSelectedColor(index);
        int space = Integer.parseInt((String)this.view.spacing.getSelectedItem());
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        this.createImage(c, space);
        this.view.previewCanvas.paintImage();
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createImage(Color color, int space) {
        List thumbnails = this.model.getThumbnails();
        if (this.maxDim == null) {
            this.maxDim(thumbnails);
        }
        int n = thumbnails.size();
        n = (int)Math.floor(Math.sqrt(n)) + 1;
        Iterator children = thumbnails.iterator();
        int w = this.maxDim.width * n + (n + 1) * space;
        int h = this.maxDim.height * n + (n + 1) * space;
        BufferedImage newImage = new BufferedImage(w, h, 1);
        Graphics2D g2 = (Graphics2D)newImage.getGraphics();
        g2.setColor(color);
        g2.fillRect(0, 0, w, h);
        int finalI = 0;
        try {
            for (int i = 0; i < n; ++i) {
                finalI = i;
                for (int j = 0; j < n; ++j) {
                    if (!children.hasNext()) {
                        return;
                    }
                    BufferedImage child = (BufferedImage)children.next();
                    g2.drawImage(child, null, (j + 1) * space + j * this.maxDim.width, (i + 1) * space + i * this.maxDim.height);
                }
            }
            ++finalI;
        }
        finally {
            double ratio = (double)thumbnails.size() / (double)n;
            double d = Math.floor(ratio);
            double diff = Math.abs(ratio - d);
            if (diff != 0.0) {
                ++finalI;
            }
            int hSub = this.maxDim.height * finalI + (finalI + 1) * space;
            this.image = newImage.getSubimage(0, 0, w, hSub);
        }
    }

    private void maxDim(List thumbnails) {
        this.maxDim = new Dimension(0, 0);
        for (BufferedImage child : thumbnails) {
            Dimension d = new Dimension(child.getWidth(), child.getHeight());
            this.maxDim = LayoutUtils.max(this.maxDim, d);
        }
    }

    private void initListeners() {
        this.view.colors.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreviewMng.this.preview();
            }
        });
        this.view.spacing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreviewMng.this.preview();
            }
        });
        this.attachButtonListener(this.view.save, 0);
        this.attachButtonListener(this.view.cancel, 2);
        this.attachButtonListener(this.view.preview, 1);
        this.view.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PreviewMng.this.model.closeWindow();
            }
        });
    }

    private void attachButtonListener(JButton button, int id) {
        button.addActionListener(this);
        button.setActionCommand("" + id);
    }

    PreviewMng(Preview view, ContainerSaver model) {
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.view = view;
        this.model = model;
        this.maxDim = null;
        this.initListeners();
    }

    BufferedImage getImage() {
        if (this.image == null) {
            this.createImage(DEFAULT_BG, 4);
        }
        return this.image;
    }

    public void actionPerformed(ActionEvent e) {
        int index = -1;
        try {
            index = Integer.parseInt(e.getActionCommand());
            switch (index) {
                case 0: {
                    this.view.closeWindow();
                    this.model.saveImage(this.getImage());
                    break;
                }
                case 2: {
                    this.view.closeWindow();
                    this.model.closeWindow();
                    break;
                }
                case 1: {
                    this.preview();
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new Error("Invalid Action ID " + index, nfe);
        }
    }
}

