/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.saver;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.hiviewer.saver.Preview;

class PreviewCanvas
extends JPanel {
    private Preview view;

    PreviewCanvas(Preview view) {
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.view = view;
        this.setDoubleBuffered(true);
    }

    void paintImage() {
        BufferedImage image = this.view.getImage();
        if (image == null) {
            return;
        }
        Dimension d = new Dimension(image.getWidth(), image.getHeight());
        this.setSize(d);
        this.setPreferredSize(d);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        BufferedImage image = this.view.getImage();
        if (image != null) {
            g2D.drawImage(image, null, 0, 0);
        }
    }
}

