/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.saver;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.saver.ContainerSaver;
import org.openmicroscopy.shoola.agents.hiviewer.saver.PreviewCanvas;
import org.openmicroscopy.shoola.agents.hiviewer.saver.PreviewMng;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class Preview
extends JDialog {
    private static final Dimension HBOX = new Dimension(5, 0);
    private static final Dimension RIGID_HBOX = new Dimension(10, 0);
    private static final Dimension WIN_SIZE = new Dimension(400, 500);
    private static final String[] gaps;
    private static final String[] bgColors;
    private static final int WHITE = 0;
    private static final int BLACK = 1;
    private static final int DARK_GRAY = 2;
    private static final int GRAY = 3;
    private static final int LIGHT_GRAY = 4;
    private static final int MAX = 4;
    private static final int GAP_TWO = 0;
    private static final int GAP_FOUR = 1;
    private static final int GAP_SIX = 2;
    private static final int GAP_HEIGHT = 3;
    private static final int GAP_TEN = 4;
    private static final int GAP_MAX = 4;
    private PreviewMng manager;
    PreviewCanvas previewCanvas;
    JButton preview;
    JButton save;
    JButton cancel;
    JComboBox colors;
    JComboBox spacing;

    private void initComponents() {
        this.colors = new JComboBox<String>(bgColors);
        this.spacing = new JComboBox<String>(gaps);
        this.spacing.setSelectedIndex(1);
        this.previewCanvas = new PreviewCanvas(this);
        this.save = new JButton("Save");
        this.save.setToolTipText(UIUtilities.formatToolTipText("Save the preview image."));
        this.cancel = new JButton("Cancel");
        this.cancel.setToolTipText(UIUtilities.formatToolTipText("Don't save the preview image."));
        this.preview = new JButton("Preview");
        this.preview.setToolTipText(UIUtilities.formatToolTipText("Preview the modified image."));
    }

    private void buildGUI() {
        IconManager im = IconManager.getInstance();
        TitlePanel tp = new TitlePanel("Preview", "Preview the image", im.getIcon(34));
        Container c = this.getContentPane();
        c.add((Component)tp, "North");
        c.add((Component)new JScrollPane(this.previewCanvas), "Center");
        c.add((Component)this.buildControlsPanel(), "East");
        c.add((Component)UIUtilities.buildComponentPanelRight(this.buildButtonPanel()), "South");
    }

    private JPanel buildControlsPanel() {
        JPanel p = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        p.setLayout(gridbag);
        c.anchor = 18;
        Component cp = Box.createRigidArea(RIGID_HBOX);
        gridbag.setConstraints(cp, c);
        p.add(cp);
        JLabel label = new JLabel("Background");
        c.gridx = 1;
        gridbag.setConstraints(label, c);
        p.add(label);
        c.gridy = 1;
        gridbag.setConstraints(this.colors, c);
        p.add(this.colors);
        c.gridy = 2;
        label = new JLabel("Spacing");
        gridbag.setConstraints(label, c);
        p.add(label);
        c.gridy = 3;
        gridbag.setConstraints(this.spacing, c);
        p.add(this.spacing);
        return p;
    }

    private JPanel buildButtonPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.save);
        p.add(Box.createRigidArea(HBOX));
        p.add(this.cancel);
        p.add(Box.createRigidArea(RIGID_HBOX));
        p.setOpaque(false);
        return p;
    }

    Preview(ContainerSaver model) {
        super(model, "Preview", true);
        this.initComponents();
        this.manager = new PreviewMng(this, model);
        this.previewCanvas.paintImage();
        this.buildGUI();
        this.setSize(WIN_SIZE);
    }

    Color getSelectedColor(int index) {
        switch (index) {
            case 1: {
                return Color.BLACK;
            }
            case 2: {
                return Color.DARK_GRAY;
            }
            case 3: {
                return Color.GRAY;
            }
            case 4: {
                return Color.LIGHT_GRAY;
            }
        }
        return Color.WHITE;
    }

    BufferedImage getImage() {
        return this.manager.getImage();
    }

    void closeWindow() {
        this.setVisible(false);
        this.dispose();
    }

    static {
        bgColors = new String[5];
        Preview.bgColors[0] = "White";
        Preview.bgColors[1] = "Black";
        Preview.bgColors[2] = "Dark gray";
        Preview.bgColors[3] = "Gray";
        Preview.bgColors[4] = "Light gray";
        gaps = new String[5];
        Preview.gaps[0] = "2";
        Preview.gaps[1] = "4";
        Preview.gaps[2] = "6";
        Preview.gaps[3] = "8";
        Preview.gaps[4] = "10";
    }
}

