/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.saver;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openmicroscopy.shoola.agents.hiviewer.saver.ContainerSaver;
import org.openmicroscopy.shoola.util.filter.file.BMPFilter;
import org.openmicroscopy.shoola.util.filter.file.JPEGFilter;
import org.openmicroscopy.shoola.util.filter.file.PNGFilter;
import org.openmicroscopy.shoola.util.filter.file.TIFFFilter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class FileChooser
extends JFileChooser {
    private static final String DEFAULT_FORMAT = "tiff";
    private static final String MSG_DIR = "The image has been saved in \n";
    private ContainerSaver window;
    private boolean display;

    private void buildGUI() {
        this.setAcceptAllFileFilterUsed(false);
        this.setDialogType(1);
        this.setFileSelectionMode(0);
        this.addChoosableFileFilter(new BMPFilter());
        this.addChoosableFileFilter(new JPEGFilter());
        PNGFilter filter = new PNGFilter();
        this.addChoosableFileFilter(filter);
        this.addChoosableFileFilter(new TIFFFilter());
        this.setFileFilter(filter);
        this.setApproveButtonText("Save as");
        File f = UIUtilities.getDefaultFolder();
        if (f != null) {
            this.setCurrentDirectory(f);
        }
    }

    private String getFormat(FileFilter filter) {
        String format = DEFAULT_FORMAT;
        if (filter instanceof JPEGFilter) {
            format = "jpg";
        } else if (filter instanceof PNGFilter) {
            format = "png";
        } else if (filter instanceof TIFFFilter) {
            format = "tif";
        } else if (filter instanceof BMPFilter) {
            format = "bmp";
        }
        return format;
    }

    private void setSelection(String extension, String fileName, String message, File[] list) {
        boolean exist = false;
        String name = fileName + "." + extension;
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].getAbsolutePath().equals(name)) continue;
            exist = true;
            break;
        }
        this.window.previewImage(extension, fileName, message, exist);
    }

    FileChooser(ContainerSaver window) {
        if (window == null) {
            throw new IllegalArgumentException("No window.");
        }
        this.window = window;
        this.display = false;
        this.buildGUI();
    }

    public void cancelSelection() {
        this.window.closeWindow();
    }

    public void approveSelection() {
        File file = this.getSelectedFile();
        if (file != null) {
            String format = this.getFormat(this.getFileFilter());
            String fileName = file.getAbsolutePath();
            String message = MSG_DIR + this.getCurrentDirectory();
            this.setSelection(format, fileName, message, this.getCurrentDirectory().listFiles());
            this.setSelectedFile(null);
            if (this.display) {
                return;
            }
        }
        super.approveSelection();
    }
}

