/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.saver;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.saver.ContainerSaver;
import org.openmicroscopy.shoola.agents.hiviewer.saver.FileChooser;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ContainerSaverUI {
    private static final String TITLE = "Save the thumbnails";
    private static final String SUMMARY = "Save the selected thumbnails as a single image.";
    private FileChooser chooser;
    private JCheckBox settings;

    private void initComponents(ContainerSaver saver) {
        this.chooser = new FileChooser(saver);
        this.settings = new JCheckBox();
        this.settings.setText("Set the current directory as default.");
        this.settings.setSelected(true);
    }

    private void buildGUI(ContainerSaver saver) {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(0, 0));
        p.add((Component)this.chooser, "Center");
        p.add((Component)UIUtilities.buildComponentPanel(this.settings), "South");
        Container c = saver.getContentPane();
        IconManager im = IconManager.getInstance();
        TitlePanel tp = new TitlePanel(TITLE, SUMMARY, im.getIcon(34));
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)tp, "North");
        c.add((Component)p, "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && UIManager.getLookAndFeel().getSupportsWindowDecorations()) {
            saver.getRootPane().setWindowDecorationStyle(6);
        }
    }

    ContainerSaverUI(ContainerSaver saver) {
        if (saver == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.initComponents(saver);
        this.buildGUI(saver);
    }

    String getCurrentDirectory() {
        return this.chooser.getCurrentDirectory().toString();
    }

    boolean isSetDefaultFolder() {
        return this.settings.isSelected();
    }
}

