/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.saver;

import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.hiviewer.HiViewerAgent;
import org.openmicroscopy.shoola.agents.hiviewer.saver.ContainerSaverManager;
import org.openmicroscopy.shoola.agents.hiviewer.saver.ContainerSaverUI;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.image.io.TIFFEncoder;
import org.openmicroscopy.shoola.util.image.io.WriterImage;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ContainerSaver
extends JDialog {
    private ContainerSaverManager manager;
    private List thumbnails;
    private String extension;
    private String name;
    private String message;
    private ContainerSaverUI uiDelegate;

    private void notifyError(String msg) {
        UserNotifier un = HiViewerAgent.getRegistry().getUserNotifier();
        un.notifyError("Save the thumbnails", msg);
    }

    public ContainerSaver(JFrame owner, List thumbnails) {
        super(owner);
        if (thumbnails == null) {
            throw new IllegalArgumentException("No images.");
        }
        this.thumbnails = thumbnails;
        this.uiDelegate = new ContainerSaverUI(this);
        this.manager = new ContainerSaverManager(this);
    }

    void previewImage(String extension, String name, String msg, boolean exist) {
        if (extension == null) {
            this.notifyError("The file extension cannot be null.");
            return;
        }
        if (name == null) {
            this.notifyError("The name cannot be null.");
            return;
        }
        this.extension = extension;
        this.name = name;
        this.message = msg;
        if (exist) {
            this.manager.showSelectionDialog();
        } else {
            this.manager.showPreview();
        }
    }

    void saveImage(BufferedImage img) {
        UserNotifier un = HiViewerAgent.getRegistry().getUserNotifier();
        this.name = this.name + "." + this.extension;
        File f = new File(this.name);
        try {
            if (this.extension.equals("tif")) {
                TIFFEncoder encoder = new TIFFEncoder(Factory.createImage(img), new DataOutputStream(new FileOutputStream(f)));
                WriterImage.saveImage(encoder);
            } else {
                WriterImage.saveImage(f, img, this.extension);
            }
            un.notifyInfo("Image saved", this.message);
            if (this.uiDelegate.isSetDefaultFolder()) {
                UIUtilities.setDefaultFolder(this.uiDelegate.getCurrentDirectory());
            }
        }
        catch (Exception e) {
            f.delete();
            un.notifyError("Save image failure", "Unable to save the image", e);
        }
        this.closeWindow();
    }

    void closeWindow() {
        this.setVisible(false);
        this.dispose();
    }

    List getThumbnails() {
        return this.thumbnails;
    }

    void showPreview() {
        this.manager.showPreview();
    }
}

