/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.layout;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageSet;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Thumbnail;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import pojos.DataObject;

public class LayoutUtils {
    private static void scaleImage(ImageNode newNode, ImageNode oldNode) {
        Thumbnail th = newNode.getThumbnail();
        th.scale(oldNode.getThumbnail().getScalingFactor());
    }

    static void noChildLayout(ImageDisplay node) {
        node.getInternalDesktop().setPreferredSize(node.getTitleBar().getMinimumSize());
        node.setVisible(true);
    }

    static Dimension maxChildDim(ImageDisplay node) {
        Dimension maxDim = new Dimension(0, 0);
        for (ImageDisplay child : node.getChildrenDisplay()) {
            maxDim = LayoutUtils.max(maxDim, child.getPreferredSize());
        }
        return maxDim;
    }

    static Dimension maxChildDim(List images) {
        Dimension maxDim = new Dimension(0, 0);
        for (ImageDisplay child : images) {
            maxDim = LayoutUtils.max(maxDim, child.getPreferredSize());
        }
        return maxDim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doSquareGridLayout(ImageDisplay root, List imageNodes) {
        Dimension d;
        Iterator children = imageNodes.iterator();
        Dimension maxDim = LayoutUtils.maxChildDim(imageNodes);
        int n = imageNodes.size();
        n = (int)Math.floor(Math.sqrt(n)) + 1;
        try {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (!children.hasNext()) {
                        return;
                    }
                    ImageDisplay child = (ImageDisplay)children.next();
                    d = child.getPreferredSize();
                    child.setBounds(j * maxDim.width, i * maxDim.height, d.width, d.height);
                }
            }
        }
        finally {
            Rectangle bounds = root.getContentsBounds();
            d = bounds.getSize();
            root.getInternalDesktop().setSize(d);
            root.getInternalDesktop().setPreferredSize(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doSquareGridLayout(ImageDisplay node, ViewerSorter sorter) {
        Dimension d;
        Dimension maxDim = LayoutUtils.maxChildDim(node);
        int n = node.getChildrenDisplay().size();
        if (n == 0) {
            node.getInternalDesktop().setPreferredSize(node.getTitleBar().getMinimumSize());
            node.setVisible(true);
            return;
        }
        n = (int)Math.floor(Math.sqrt(n)) + 1;
        List l = sorter.sort(node.getChildrenDisplay());
        Iterator children = l.iterator();
        try {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (!children.hasNext()) {
                        return;
                    }
                    ImageDisplay child = (ImageDisplay)children.next();
                    d = child.getPreferredSize();
                    child.setBounds(j * maxDim.width, i * maxDim.height, d.width, d.height);
                }
            }
        }
        finally {
            Rectangle bounds = node.getContentsBounds();
            d = bounds.getSize();
            node.getInternalDesktop().setSize(d);
            node.getInternalDesktop().setPreferredSize(d);
        }
    }

    static void redoLayout(ImageSet node, ImageSet oldNode, Collection newNodes, Set oldNodes) {
        int n = newNodes.size();
        if (n == 0) {
            node.getInternalDesktop().setPreferredSize(node.getTitleBar().getMinimumSize());
            node.setVisible(true);
            return;
        }
        for (ImageDisplay child : newNodes) {
            Object oho;
            ImageDisplay oldChild;
            long id;
            Iterator j;
            Object ho = child.getHierarchyObject();
            Class<?> klass = ho.getClass();
            Object pho = child.getParentDisplay().getHierarchyObject();
            Class<?> pKlass = pho.getClass();
            if (!(ho instanceof DataObject)) continue;
            if (pho instanceof DataObject) {
                j = oldNodes.iterator();
                id = ((DataObject)ho).getId();
                long pid = ((DataObject)pho).getId();
                while (j.hasNext()) {
                    oldChild = (ImageDisplay)j.next();
                    oho = oldChild.getHierarchyObject();
                    if (oldChild.getParentDisplay() == null) continue;
                    Object poho = oldChild.getParentDisplay().getHierarchyObject();
                    if (!(oho instanceof DataObject) || ((DataObject)oho).getId() != id || !oho.getClass().equals(klass) || ((DataObject)poho).getId() != pid || !poho.getClass().equals(pKlass)) continue;
                    if (child instanceof ImageNode) {
                        LayoutUtils.scaleImage((ImageNode)child, (ImageNode)oldChild);
                    }
                    child.setBounds(oldChild.getBounds());
                }
                continue;
            }
            j = oldNodes.iterator();
            id = ((DataObject)ho).getId();
            while (j.hasNext()) {
                oldChild = (ImageDisplay)j.next();
                oho = oldChild.getHierarchyObject();
                if (oldChild.getParentDisplay() == null || !(oho instanceof DataObject) || ((DataObject)oho).getId() != id || !oho.getClass().equals(klass)) continue;
                if (child instanceof ImageNode) {
                    LayoutUtils.scaleImage((ImageNode)child, (ImageNode)oldChild);
                }
                child.setBounds(oldChild.getBounds());
            }
        }
        if (oldNode == null) {
            Rectangle bounds = node.getContentsBounds();
            Dimension d = bounds.getSize();
            node.getInternalDesktop().setSize(d);
            node.getInternalDesktop().setPreferredSize(d);
        } else {
            Dimension d = oldNode.getRestoreSize();
            if (oldNode.isCollapsed()) {
                Rectangle r = oldNode.getBounds();
                Rectangle bounds = new Rectangle(r.x, r.y, d.width, d.height);
                node.setBounds(bounds);
                node.setPreferredSize(d);
                node.getInternalDesktop().setSize(d);
                node.getInternalDesktop().setPreferredSize(d);
                node.setCollapsed(true);
            } else {
                node.setBounds(oldNode.getBounds());
                node.getInternalDesktop().setSize(d);
                node.getInternalDesktop().setPreferredSize(d);
            }
        }
    }

    public static Dimension max(Dimension a, Dimension b) {
        int areaA = a.width * a.height;
        int areaB = b.width * b.height;
        if (areaA < areaB) {
            return b;
        }
        return a;
    }
}

