/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.layout;

import org.openmicroscopy.shoola.agents.hiviewer.layout.FlatLayout;
import org.openmicroscopy.shoola.agents.hiviewer.layout.Layout;
import org.openmicroscopy.shoola.agents.hiviewer.layout.SquaryLayout;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;

public class LayoutFactory {
    public static final int SQUARY_LAYOUT = 1;
    public static final int FLAT_LAYOUT = 2;

    public static Layout createLayout(int type, ViewerSorter sorter) {
        if (sorter == null) {
            throw new IllegalArgumentException("Invalid argument.");
        }
        switch (type) {
            case 1: {
                return new SquaryLayout(sorter);
            }
            case 2: {
                return new FlatLayout(sorter);
            }
        }
        throw new IllegalArgumentException("Unsupported layout type: " + type + ".");
    }

    public static Layout getDefaultLayout(ViewerSorter sorter) {
        return LayoutFactory.createLayout(LayoutFactory.getDefaultLayoutIndex(), sorter);
    }

    public static int getDefaultLayoutIndex() {
        return 1;
    }

    public static String getLayoutDescription(int type) {
        switch (type) {
            case 1: {
                return "Recursively lays out all nodes in a container display in a square grid. The size of each cell in the grid is that of the largest child in the container.";
            }
            case 2: {
                return "Layout the images in a square grid.";
            }
        }
        return "";
    }
}

