/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.layout;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageSet;
import org.openmicroscopy.shoola.agents.hiviewer.layout.Layout;
import org.openmicroscopy.shoola.agents.hiviewer.layout.LayoutUtils;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import pojos.DataObject;

class FlatLayout
implements Layout {
    static final String DESCRIPTION = "Layout the images in a square grid.";
    private ViewerSorter sorter;
    private List<ImageNode> images = new ArrayList<ImageNode>();
    private ImageSet root;
    private Set oldNodes;

    FlatLayout(ViewerSorter sorter) {
        this.sorter = sorter;
    }

    public void doLayout() {
        if (this.root != null) {
            List l = this.sorter.sort(this.images);
            if (this.oldNodes == null || this.oldNodes.size() != l.size()) {
                LayoutUtils.doSquareGridLayout((ImageDisplay)this.root, l);
            } else {
                LayoutUtils.redoLayout(this.root, null, l, this.oldNodes);
            }
        }
    }

    public void visit(ImageNode node) {
        this.images.add(node);
    }

    public void visit(ImageSet node) {
        if (!(node.getHierarchyObject() instanceof DataObject) && node.getParentDisplay() == null) {
            this.root = node;
        }
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public int getIndex() {
        return 2;
    }

    public void setOldNodes(Set oldNodes) {
        this.oldNodes = oldNodes;
    }
}

