/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.cmd;

import org.openmicroscopy.shoola.agents.hiviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ActionCmd;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ZoomVisitor;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;

public class ZoomCmd
implements ActionCmd {
    public static final int ZOOM_IN = 0;
    public static final int ZOOM_OUT = 1;
    public static final int ZOOM_FIT = 2;
    private static final double INCREMENT = 0.25;
    private HiViewer model;
    private static int index;

    private boolean checkIndex(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public ZoomCmd(HiViewer model, int i) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (!this.checkIndex(i)) {
            throw new IllegalArgumentException("Index not valid.");
        }
        this.model = model;
        index = i;
    }

    static double calculateFactor(double currentScale) {
        double factor = currentScale;
        switch (index) {
            case 0: {
                if (currentScale >= 1.0) {
                    factor = 1.0;
                    break;
                }
                factor += 0.25;
                break;
            }
            case 1: {
                if (currentScale <= 0.25) {
                    factor = 0.25;
                    break;
                }
                factor -= 0.25;
                break;
            }
            case 2: {
                factor = 0.5;
            }
        }
        return factor;
    }

    public void execute() {
        ZoomVisitor visitor = new ZoomVisitor(this.model);
        Browser browser = this.model.getBrowser();
        if (browser == null) {
            return;
        }
        int layout = browser.getSelectedLayout();
        if (layout == 2) {
            browser.accept(visitor, 0);
        } else {
            ImageDisplay selectedDisplay = browser.getLastSelectedDisplay();
            if (selectedDisplay == null) {
                return;
            }
            if (selectedDisplay.getParentDisplay() == null) {
                return;
            }
            selectedDisplay.accept(visitor);
        }
        this.model.layoutZoomedNodes();
    }
}

