/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.cmd;

import java.util.Set;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageFinder;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ActionCmd;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewerFactory;
import pojos.ImageData;

public class ViewHierarchyCmd
implements ActionCmd {
    public static final int IN_CGCI = 0;
    public static final int IN_PDI = 1;
    private HiViewer model;
    private int index;

    private boolean checkIndex(int i) {
        switch (i) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public ViewHierarchyCmd(HiViewer model, int index) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (!this.checkIndex(index)) {
            throw new IllegalArgumentException("Index not supported.");
        }
        this.model = model;
        this.index = index;
    }

    public void execute() {
        Set<ImageData> images;
        Browser browser = this.model.getBrowser();
        ImageDisplay selectedDisplay = null;
        if (browser != null) {
            selectedDisplay = browser.getLastSelectedDisplay();
        }
        if (selectedDisplay == null && browser != null) {
            images = browser.getImages();
        } else {
            ImageFinder visitor = new ImageFinder();
            selectedDisplay.accept(visitor, 0);
            images = visitor.getImages();
        }
        if (images == null || images.size() == 0) {
            return;
        }
        HiViewer viewer = null;
        switch (this.index) {
            case 0: {
                viewer = HiViewerFactory.getCGCIViewer(images, this.model.getExperimenter(), this.model.getUserGroupID());
                break;
            }
            case 1: {
                viewer = HiViewerFactory.getPDIViewer(images, this.model.getExperimenter(), this.model.getUserGroupID());
            }
        }
        if (viewer != null) {
            viewer.activate(this.model.getUI().getBounds());
        }
    }
}

