/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.cmd;

import java.awt.Rectangle;
import java.util.Set;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.hiviewer.HiViewerAgent;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ActionCmd;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.env.event.EventBus;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.ProjectData;

public class ViewCmd
implements ActionCmd {
    private HiViewer model;
    private DataObject hierarchyObject;

    public ViewCmd(DataObject hierarchyObject) {
        if (hierarchyObject == null) {
            throw new IllegalArgumentException("No hierarchy object.");
        }
        if (!(hierarchyObject instanceof ImageData)) {
            throw new IllegalArgumentException("Object must be an ImageData object.");
        }
        this.hierarchyObject = hierarchyObject;
    }

    public ViewCmd(HiViewer model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
    }

    public ViewCmd(HiViewer model, DataObject hierarchyObject) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.hierarchyObject = hierarchyObject;
        this.model = model;
    }

    public void execute() {
        Browser browser;
        if (this.model != null && this.hierarchyObject == null && (browser = this.model.getBrowser()) != null) {
            ImageDisplay d = browser.getLastSelectedDisplay();
            this.hierarchyObject = (DataObject)d.getHierarchyObject();
        }
        if (this.hierarchyObject == null) {
            return;
        }
        Rectangle bounds = null;
        if (this.model != null) {
            bounds = this.model.getUI().getBounds();
        }
        if (this.hierarchyObject instanceof DatasetData) {
            HiViewerAgent.browse(1, ((DatasetData)this.hierarchyObject).getId(), this.model.getExperimenter(), this.model.getUserGroupID(), bounds);
        } else if (this.hierarchyObject instanceof ProjectData) {
            HiViewerAgent.browse(0, ((ProjectData)this.hierarchyObject).getId(), this.model.getExperimenter(), this.model.getUserGroupID(), bounds);
        } else if (this.hierarchyObject instanceof CategoryGroupData) {
            HiViewerAgent.browse(2, ((CategoryGroupData)this.hierarchyObject).getId(), this.model.getExperimenter(), this.model.getUserGroupID(), bounds);
        } else if (this.hierarchyObject instanceof CategoryData) {
            HiViewerAgent.browse(3, ((CategoryData)this.hierarchyObject).getId(), this.model.getExperimenter(), this.model.getUserGroupID(), bounds);
        } else if (this.hierarchyObject instanceof ImageData) {
            EventBus eventBus = HiViewerAgent.getRegistry().getEventBus();
            ImageData is = (ImageData)this.hierarchyObject;
            if (this.model != null) {
                Set images = this.model.getBrowser().getSelectedDisplays();
                for (ImageDisplay d : images) {
                    is = (ImageData)d.getHierarchyObject();
                    eventBus.post(new ViewImage(is.getId(), is.getDefaultPixels().getId(), is.getName(), bounds));
                }
            } else {
                eventBus.post(new ViewImage(is.getId(), is.getDefaultPixels().getId(), is.getName(), bounds));
            }
        }
    }
}

