/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.cmd;

import java.util.Set;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageFinder;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ActionCmd;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;

public class SaveThumbnailsCmd
implements ActionCmd {
    private HiViewer model;

    public SaveThumbnailsCmd(HiViewer model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
    }

    public void execute() {
        Browser browser = this.model.getBrowser();
        if (browser == null) {
            return;
        }
        Set<ImageNode> thumbnails = null;
        if (browser.getSelectedLayout() == 2) {
            thumbnails = browser.getImageNodes();
        } else {
            ImageDisplay selectedDisplay = browser.getLastSelectedDisplay();
            if (selectedDisplay.containsImages()) {
                ImageFinder finder = new ImageFinder();
                selectedDisplay.accept(finder, 0);
                thumbnails = finder.getImageNodes();
            }
        }
        if (thumbnails == null) {
            return;
        }
        this.model.saveThumbnails(thumbnails);
    }
}

