/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.cmd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ActionCmd;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import pojos.DataObject;

public class RemoveCmd
implements ActionCmd {
    private HiViewer model;

    public RemoveCmd(HiViewer model) {
        if (model == null) {
            throw new IllegalArgumentException("No model");
        }
        this.model = model;
    }

    public void execute() {
        Browser browser = this.model.getBrowser();
        if (browser == null) {
            return;
        }
        Set nodes = browser.getSelectedDisplays();
        if (nodes.size() == 0) {
            return;
        }
        Iterator i = nodes.iterator();
        ArrayList<ImageDisplay> toRemove = new ArrayList<ImageDisplay>();
        while (i.hasNext()) {
            ImageDisplay n = (ImageDisplay)i.next();
            if (!(n.getHierarchyObject() instanceof DataObject)) continue;
            toRemove.add(n);
        }
        if (toRemove.size() != 0) {
            this.model.removeObjects(toRemove);
        }
    }
}

