/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.cmd;

import java.util.HashSet;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageSet;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.HiViewerVisitor;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import pojos.AnnotationData;
import pojos.DatasetData;
import pojos.ImageData;

public class ImgDisplayAnnotationVisitor
extends HiViewerVisitor {
    protected AnnotationData data;
    protected long hierarchyObjectID;

    public ImgDisplayAnnotationVisitor(HiViewer model, AnnotationData data, long hierarchyObjectID) {
        super(model);
        if (hierarchyObjectID < 0L) {
            throw new IllegalArgumentException("ID not valid.");
        }
        this.hierarchyObjectID = hierarchyObjectID;
        this.data = data;
    }

    public void visit(ImageNode node) {
        ImageData is = (ImageData)node.getHierarchyObject();
        if (is.getId() == this.hierarchyObjectID) {
            HashSet<AnnotationData> set = new HashSet<AnnotationData>(1);
            set.add(this.data);
            is.setAnnotations(set);
        }
    }

    public void visit(ImageSet node) {
        DatasetData ds;
        Object ho = node.getHierarchyObject();
        if (ho instanceof DatasetData && (ds = (DatasetData)ho).getId() == this.hierarchyObjectID) {
            HashSet<AnnotationData> set = new HashSet<AnnotationData>(1);
            set.add(this.data);
            ds.setAnnotations(set);
        }
    }
}

