/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.cmd;

import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.openmicroscopy.shoola.agents.hiviewer.Colors;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageSet;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder.FindData;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.HiViewerVisitor;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.util.ui.RegExFactory;
import pojos.AnnotationData;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.ProjectData;

class FindRegExVisitor
extends HiViewerVisitor {
    private Color color = Colors.getInstance().getColor(2);
    private Set foundNodes;
    private Pattern pattern;
    private FindData findContext;

    private String getName(Object userObject) {
        if (userObject instanceof ProjectData) {
            return ((ProjectData)userObject).getName();
        }
        if (userObject instanceof DatasetData) {
            return ((DatasetData)userObject).getName();
        }
        if (userObject instanceof ImageData) {
            return ((ImageData)userObject).getName();
        }
        if (userObject instanceof CategoryGroupData) {
            return ((CategoryGroupData)userObject).getName();
        }
        if (userObject instanceof CategoryData) {
            return ((CategoryData)userObject).getName();
        }
        return null;
    }

    private String getDescription(Object userObject) {
        if (userObject instanceof ProjectData) {
            return ((ProjectData)userObject).getDescription();
        }
        if (userObject instanceof DatasetData) {
            return ((DatasetData)userObject).getDescription();
        }
        if (userObject instanceof ImageData) {
            return ((ImageData)userObject).getDescription();
        }
        if (userObject instanceof CategoryGroupData) {
            return ((CategoryGroupData)userObject).getDescription();
        }
        if (userObject instanceof CategoryData) {
            return ((CategoryData)userObject).getDescription();
        }
        return null;
    }

    private String getAnnotation(Object userObject) {
        Set annotations = null;
        if (userObject instanceof DatasetData) {
            annotations = ((DatasetData)userObject).getAnnotations();
        } else if (userObject instanceof ImageData) {
            annotations = ((DatasetData)userObject).getAnnotations();
        }
        if (annotations == null || annotations.size() == 0) {
            return null;
        }
        AnnotationData data = (AnnotationData)annotations.toArray()[0];
        if (data == null) {
            return null;
        }
        return data.getText();
    }

    private void setFoundNode(ImageDisplay node) {
        String description;
        String name;
        Object userObject = node.getHierarchyObject();
        Color c = null;
        if (this.findContext.nameSelected && (name = this.getName(userObject)) != null && RegExFactory.find(this.pattern, name)) {
            this.foundNodes.add(node);
            c = this.color;
        }
        if (this.findContext.descriptionSelected && (description = this.getDescription(userObject)) != null && RegExFactory.find(this.pattern, description)) {
            this.foundNodes.add(node);
            c = this.color;
        }
        if (this.findContext.annotationSelected) {
            String s = this.getAnnotation(userObject);
            if (s == null) {
                return;
            }
            if (RegExFactory.find(this.pattern, s)) {
                this.foundNodes.add(node);
                c = this.color;
            }
        }
        node.setHighlight(c);
    }

    FindRegExVisitor(HiViewer viewer, Pattern pattern, FindData findContext) {
        super(viewer);
        if (pattern == null) {
            throw new IllegalArgumentException("No pattern.");
        }
        if (findContext == null) {
            throw new IllegalArgumentException("No context.");
        }
        this.pattern = pattern;
        this.findContext = findContext;
        this.foundNodes = new HashSet();
    }

    public Set getFoundNodes() {
        return this.foundNodes;
    }

    public void visit(ImageNode node) {
        this.setFoundNode(node);
    }

    public void visit(ImageSet node) {
        this.setFoundNode(node);
    }
}

