/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.cmd;

import java.util.regex.Pattern;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder.FindData;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ActionCmd;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.FindRegExVisitor;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.TreeView;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;

public class FindRegExCmd
implements ActionCmd {
    private HiViewer model;
    private Pattern pattern;
    private FindData findContext;

    public FindRegExCmd(HiViewer model, Pattern pattern, FindData findContext) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("No pattern.");
        }
        if (findContext == null) {
            throw new IllegalArgumentException("No context.");
        }
        this.model = model;
        this.pattern = pattern;
        this.findContext = findContext;
    }

    public void execute() {
        TreeView tree;
        Browser browser = this.model.getBrowser();
        FindRegExVisitor visitor = new FindRegExVisitor(this.model, this.pattern, this.findContext);
        if (browser != null) {
            browser.accept(visitor);
        }
        if ((tree = this.model.getTreeView()) != null) {
            tree.repaint();
        }
        this.model.setFoundResults(visitor.getFoundNodes());
    }
}

