/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.cmd;

import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageSet;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.HiViewerVisitor;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ImageData;

public class FindAnnotatedVisitor
extends HiViewerVisitor {
    private DataObject ho;

    public FindAnnotatedVisitor(HiViewer model, DataObject ho) {
        super(model);
        if (ho == null) {
            throw new IllegalArgumentException("No DataObject.");
        }
        this.ho = ho;
    }

    public void visit(ImageNode node) {
        Object object = node.getHierarchyObject();
        if (object instanceof ImageData && ((ImageData)object).getId() == this.ho.getId()) {
            node.setNodeDecoration();
            node.setHierarchyObject(this.ho);
            node.repaint();
        }
    }

    public void visit(ImageSet node) {
        Object object = node.getHierarchyObject();
        if (object instanceof DatasetData && ((DatasetData)object).getId() == this.ho.getId()) {
            IconManager im = IconManager.getInstance();
            node.setHierarchyObject(this.ho);
            if (node.isAnnotated()) {
                node.setFrameIcon(im.getIcon(41));
            } else {
                node.setFrameIcon(im.getIcon(23));
            }
            node.repaint();
        }
    }
}

