/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.cmd;

import java.util.Iterator;
import java.util.List;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageSet;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.HiViewerVisitor;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import pojos.DatasetData;
import pojos.ImageData;

public class DataSaveVisitor
extends HiViewerVisitor {
    private IconManager icons;
    private List nodes;

    public DataSaveVisitor(HiViewer model, List nodes) {
        super(model);
        this.nodes = nodes;
        this.icons = IconManager.getInstance();
    }

    public void visit(ImageNode node) {
        long id = ((ImageData)node.getHierarchyObject()).getId();
        for (Object object : this.nodes) {
            if (!(object instanceof ImageData) || ((ImageData)object).getId() != id) continue;
            node.setHierarchyObject(object);
            node.setNodeDecoration();
        }
    }

    public void visit(ImageSet node) {
        Object uo = node.getHierarchyObject();
        if (!(uo instanceof DatasetData)) {
            return;
        }
        Iterator i = this.nodes.iterator();
        long id = ((DatasetData)uo).getId();
        while (i.hasNext()) {
            Object object = i.next();
            if (!(object instanceof DatasetData) || ((DatasetData)object).getId() != id) continue;
            node.setHierarchyObject(object);
            if (!(uo instanceof DatasetData)) continue;
            if (node.isAnnotated()) {
                node.setFrameIcon(this.icons.getIcon(41));
                continue;
            }
            node.setFrameIcon(this.icons.getIcon(23));
        }
    }
}

