/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.cmd;

import java.util.Iterator;
import java.util.Set;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ActionCmd;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import pojos.ImageData;

public class ClassifyCmd
implements ActionCmd {
    public static final int CLASSIFICATION_MODE = 0;
    public static final int DECLASSIFICATION_MODE = 1;
    private int mode;
    private ImageData[] images;
    private HiViewer model;

    private void checkMode(int m) {
        switch (m) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Mode not supported.");
            }
        }
    }

    private ImageData[] getImages() {
        ImageData[] images = null;
        if (this.model.getBrowser() == null) {
            return images;
        }
        Set nodes = this.model.getBrowser().getSelectedDisplays();
        if (nodes != null) {
            Iterator i = nodes.iterator();
            images = new ImageData[nodes.size()];
            int index = 0;
            while (i.hasNext()) {
                Object x = ((ImageDisplay)i.next()).getHierarchyObject();
                if (!(x instanceof ImageData)) continue;
                images[index] = (ImageData)x;
                ++index;
            }
        }
        return images;
    }

    public ClassifyCmd(HiViewer model, int mode) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.checkMode(mode);
        this.mode = mode;
        this.model = model;
        this.images = this.getImages();
    }

    public ClassifyCmd(HiViewer model, ImageData image, int mode) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (image == null) {
            throw new IllegalArgumentException("No image to categorise.");
        }
        this.checkMode(mode);
        this.mode = mode;
        this.model = model;
        this.images = new ImageData[1];
        this.images[0] = image;
    }

    public void execute() {
        this.model.classifyImages(this.images, this.mode);
    }
}

