/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.cmd;

import java.util.Set;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoard;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ActionCmd;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ImageData;

public class AnnotateCmd
implements ActionCmd {
    private HiViewer model;
    private ImageDisplay node;

    public AnnotateCmd(HiViewer model, ImageDisplay node) {
        if (model == null) {
            throw new IllegalArgumentException("No model");
        }
        this.model = model;
        this.node = node;
    }

    public void execute() {
        Set nodes;
        boolean b = false;
        Browser browser = this.model.getBrowser();
        if (this.node == null && browser != null) {
            this.node = browser.getLastSelectedDisplay();
            b = true;
        }
        if (this.node == null) {
            return;
        }
        if (this.node.getHierarchyObject() == null) {
            return;
        }
        if (b && (nodes = browser.getSelectedDisplays()).size() > 1) {
            this.model.annotateDataObjects(nodes);
            return;
        }
        DataObject hierarchyObject = (DataObject)this.node.getHierarchyObject();
        if (hierarchyObject instanceof DatasetData || hierarchyObject instanceof ImageData) {
            ClipBoard cb = this.model.getClipBoard();
            if (b) {
                if (cb != null) {
                    cb.setSelectedPane(0, null);
                }
            } else {
                if (cb != null) {
                    cb.setSelectedPane(0, this.node);
                }
                if (browser != null) {
                    browser.setSelectedDisplay(this.node);
                }
            }
        }
    }
}

