/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.clipboard.info;

import java.text.NumberFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import pojos.PixelsData;

class InfoPaneUtil {
    static final String WAVELENGTHS = "Emissions wavelengths";
    private static final String MICRONS = "(in \u00b5)";
    private static final String SIZE_X = "Size X";
    private static final String SIZE_Y = "Size Y";
    private static final String PIXEL_SIZE_X = "Pixel size X (in \u00b5)";
    private static final String PIXEL_SIZE_Y = "Pixel size Y (in \u00b5)";
    private static final String PIXEL_SIZE_Z = "Pixel size Z (in \u00b5)";
    private static final String SECTIONS = "Number of sections";
    private static final String TIMEPOINTS = "Number of timepoints";
    private static final String PIXEL_TYPE = "Pixel Type";

    InfoPaneUtil() {
    }

    static Map transformPixelsData(PixelsData data) {
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>(9);
        if (data == null) {
            details.put(SIZE_X, "");
            details.put(SIZE_Y, "");
            details.put(SECTIONS, "");
            details.put(TIMEPOINTS, "");
            details.put(PIXEL_SIZE_X, "");
            details.put(PIXEL_SIZE_Y, "");
            details.put(PIXEL_SIZE_Z, "");
            details.put(PIXEL_TYPE, "");
        } else {
            NumberFormat nf = NumberFormat.getInstance();
            details.put(SIZE_X, "" + data.getSizeX());
            details.put(SIZE_Y, "" + data.getSizeY());
            details.put(SECTIONS, "" + data.getSizeZ());
            details.put(TIMEPOINTS, "" + data.getSizeT());
            try {
                details.put(PIXEL_SIZE_X, nf.format(data.getPixelSizeX()));
                details.put(PIXEL_SIZE_Y, nf.format(data.getPixelSizeY()));
                details.put(PIXEL_SIZE_Z, nf.format(data.getPixelSizeZ()));
                details.put(PIXEL_TYPE, "" + data.getPixelType());
            }
            catch (Exception e) {
                details.put(PIXEL_SIZE_X, "");
                details.put(PIXEL_SIZE_Y, "");
                details.put(PIXEL_SIZE_Z, "");
                details.put(PIXEL_TYPE, "");
            }
        }
        details.put(WAVELENGTHS, "");
        return details;
    }
}

