/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.clipboard.info;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.info.InfoPane;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.info.InfoPaneUtil;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class InfoPaneUI
extends JPanel {
    private static String EDIT_MSG = "Information for ";
    private static String DEFAULT_MSG = "No information available";
    private InfoPane model;
    private JPanel contentPanel;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private Map<String, JTextField> fields;

    private void initComponents() {
        this.titleLabel = new JLabel(DEFAULT_MSG);
        this.titlePanel = new JPanel();
        this.titlePanel.setLayout(new BoxLayout(this.titlePanel, 1));
        this.titlePanel.add(this.titleLabel);
        this.titlePanel.add(new JSeparator());
        this.contentPanel = this.buildContentPanel(InfoPaneUtil.transformPixelsData(null));
    }

    private JPanel buildContentPanel(Map details) {
        JPanel content = new JPanel();
        content.setLayout(new GridBagLayout());
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 3, 3, 3);
        Iterator i = details.keySet().iterator();
        this.fields = new HashMap<String, JTextField>(details.size());
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int h = fm.getHeight();
        Dimension d = new Dimension(60, h + 4);
        while (i.hasNext()) {
            ++c.gridy;
            c.gridx = 0;
            String key = (String)i.next();
            String value = (String)details.get(key);
            JLabel label = UIUtilities.setTextFont(key);
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            content.add((Component)label, c);
            JTextField area = new JTextField(value);
            area.setEditable(false);
            area.setEnabled(false);
            label.setLabelFor(area);
            this.fields.put(key, area);
            c.gridx = 1;
            area.setPreferredSize(d);
            c.weightx = 0.5;
            content.add((Component)area, c);
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            content.add((Component)new JLabel(), c);
        }
        return content;
    }

    private void resetValues(Map details) {
        Iterator<String> i = this.fields.keySet().iterator();
        String text = "";
        while (i.hasNext()) {
            String key = i.next();
            if (details != null) {
                text = (String)details.get(key);
            }
            JTextField field = this.fields.get(key);
            field.setText(text);
        }
    }

    private void buildGUI() {
        double[][] tl = new double[][]{{-1.0}, {-2.0, -2.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])tl));
        this.add((Component)this.titlePanel, "0, 0, f, t");
        this.add((Component)this.contentPanel, "0, 1, f, t");
    }

    InfoPaneUI(InfoPane model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    void displayDetails(Map details, String name) {
        this.resetValues(details);
        if (details == null || details.size() == 0) {
            this.titleLabel.setText(DEFAULT_MSG);
            this.contentPanel.setVisible(false);
        } else {
            this.contentPanel.setVisible(true);
            this.titleLabel.setText(EDIT_MSG + name);
        }
        this.validate();
        this.repaint();
    }
}

