/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.clipboard.info;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoard;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoardPane;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.info.InfoPaneUI;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.info.InfoPaneUtil;
import org.openmicroscopy.shoola.env.data.model.ChannelMetadata;
import pojos.ImageData;

public class InfoPane
extends ClipBoardPane {
    private InfoPaneUI uiDelegate = new InfoPaneUI(this);

    public InfoPane(ClipBoard model) {
        super(model);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.add((Component)this.uiDelegate, c);
    }

    public void setChannelsMetadata(List l, ImageData data) {
        if (data != null && l != null) {
            Map details = InfoPaneUtil.transformPixelsData(data.getDefaultPixels());
            String s = "";
            Iterator k = l.iterator();
            int j = 0;
            while (k.hasNext()) {
                s = s + ((ChannelMetadata)k.next()).getEmissionWavelength();
                if (j != l.size() - 1) {
                    s = s + ", ";
                }
                ++j;
            }
            details.put("Emissions wavelengths", s);
            this.uiDelegate.displayDetails(details, data.getName());
        }
    }

    public void onDisplayChange(ImageDisplay selectedDisplay) {
        if (this.model.getSelectedPaneIndex() != 4) {
            return;
        }
        if (selectedDisplay == null) {
            this.uiDelegate.displayDetails(null, null);
            return;
        }
        Object ho = selectedDisplay.getHierarchyObject();
        if (ho == null) {
            this.uiDelegate.displayDetails(null, null);
            return;
        }
        if (ho instanceof ImageData) {
            ImageData data = (ImageData)ho;
            this.model.retrieveChannelsMetadata(data);
            Map details = InfoPaneUtil.transformPixelsData(data.getDefaultPixels());
            this.uiDelegate.displayDetails(details, data.getName());
        } else {
            this.uiDelegate.displayDetails(null, null);
        }
    }

    public String getPaneName() {
        return "Info";
    }

    public Icon getPaneIcon() {
        return IconManager.getInstance().getIcon(IconManager.INFO);
    }

    public int getPaneIndex() {
        return 4;
    }

    public String getPaneDescription() {
        return "Image's information.";
    }
}

