/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder.FindPane;
import org.openmicroscopy.shoola.agents.hiviewer.util.TreeCellRenderer;

class FindResultsPane
extends JTree {
    private static final String ROOT = "Results";
    private static final String EMPTY = "Empty";
    private FindPane model;
    private Map<ImageDisplay, DefaultMutableTreeNode> identityMap;

    private void initialize() {
        this.setRootVisible(false);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setCellRenderer(new TreeCellRenderer(false, true));
        this.getSelectionModel().setSelectionMode(1);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                FindResultsPane.this.onClick(e);
            }

            public void mouseReleased(MouseEvent e) {
                FindResultsPane.this.onClick(e);
            }
        });
    }

    private void onClick(MouseEvent me) {
        int row = this.getRowForLocation(me.getX(), me.getY());
        if (row != -1) {
            this.setSelectionRow(row);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
            this.model.setSelectedNode(node);
            if (me.isPopupTrigger()) {
                Object uo = node.getUserObject();
                if (uo instanceof String) {
                    return;
                }
                ImageDisplay object = (ImageDisplay)uo;
                this.model.showMenu(this, me.getPoint(), object);
            }
        }
    }

    private boolean hasBeenAdded(DefaultMutableTreeNode child, DefaultMutableTreeNode parent) {
        DefaultTreeModel tm = (DefaultTreeModel)this.getModel();
        int n = tm.getChildCount(parent);
        for (int i = 0; i < n; ++i) {
            if (tm.getChild(parent, i) != child) continue;
            return true;
        }
        return false;
    }

    private void buildTreeNode(ImageDisplay node) {
        DefaultMutableTreeNode root;
        DefaultTreeModel tm = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode dtn = this.identityMap.get(node);
        if (dtn == null) {
            dtn = new DefaultMutableTreeNode(node);
            this.identityMap.put(node, dtn);
        }
        if (!this.hasBeenAdded(dtn, root = (DefaultMutableTreeNode)tm.getRoot())) {
            tm.insertNodeInto(dtn, root, root.getChildCount());
        }
    }

    private void buildTree(List nodes) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(ROOT);
        DefaultTreeModel dtm = new DefaultTreeModel(root);
        this.setModel(dtm);
        this.setShowsRootHandles(true);
        if (nodes.size() == 0) {
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(EMPTY);
            DefaultTreeModel tm = (DefaultTreeModel)this.getModel();
            tm.insertNodeInto(childNode, root, root.getChildCount());
        } else {
            Iterator i = nodes.iterator();
            while (i.hasNext()) {
                this.buildTreeNode((ImageDisplay)i.next());
            }
        }
        this.expandPath(new TreePath(root.getPath()));
        dtm.reload();
    }

    FindResultsPane(FindPane model, List nodes) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (nodes == null) {
            throw new IllegalArgumentException("No nodes to display.");
        }
        this.model = model;
        this.identityMap = new HashMap<ImageDisplay, DefaultMutableTreeNode>();
        this.initialize();
        this.buildTree(nodes);
    }

    int getSizeResults() {
        return this.identityMap.size();
    }

    void findNext() {
        int n;
        int[] rows = this.getSelectionRows();
        int index = rows == null || rows.length == 0 ? 0 : rows[0];
        if (index < (n = this.getSizeResults() - 1)) {
            ++index;
        } else if (index == n) {
            index = 0;
        }
        this.setSelectionRow(index);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        this.model.setSelectedNode(node);
    }

    void findPrevious() {
        int[] rows = this.getSelectionRows();
        int index = rows == null || rows.length == 0 ? 0 : rows[0];
        if (index > 0) {
            --index;
        } else if (index == 0) {
            index = this.getSizeResults() - 1;
        }
        this.setSelectionRow(index);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        this.model.setSelectedNode(node);
    }
}

