/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder;

import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder.FindPane;

class FindPopupMenu
extends JPopupMenu {
    private static final String NAME_IN_NAME = "Find in name";
    private static final String DESCRIPTION_IN_NAME = "Finds the occurence of the phrase in the name.";
    private static final String NAME_IN_DESCRIPTION = "Find in description";
    private static final String DESCRIPTION_IN_DESCRIPTION = "Finds the occurence of the phrase in the description.";
    private FindPane model;
    private JCheckBoxMenuItem inNameItem;
    private JCheckBoxMenuItem inDescriptionItem;

    private void createMenuItems() {
        this.inNameItem = new JCheckBoxMenuItem(NAME_IN_NAME);
        this.inNameItem.setToolTipText(DESCRIPTION_IN_NAME);
        this.inNameItem.setSelected(this.model.isNameSelected());
        this.inNameItem.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                FindPopupMenu.this.model.setNameSelected(item.isSelected());
            }
        });
        this.inDescriptionItem = new JCheckBoxMenuItem(NAME_IN_DESCRIPTION);
        this.inDescriptionItem.setToolTipText(DESCRIPTION_IN_DESCRIPTION);
        this.inDescriptionItem.setSelected(this.model.isDescriptionSelected());
        this.inDescriptionItem.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                FindPopupMenu.this.model.setDescriptionSelected(item.isSelected());
            }
        });
    }

    private void buildGUI() {
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.add(this.inNameItem);
        this.add(this.inDescriptionItem);
    }

    FindPopupMenu(FindPane model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.createMenuItems();
        this.buildGUI();
    }
}

