/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder.ClearAction;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder.FilterMenuAction;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder.FindNextAction;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder.FindPane;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder.FindPreviousAction;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder.FindResultsPane;
import org.openmicroscopy.shoola.util.ui.HistoryDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class FindPaneUI
extends JPanel
implements MouseListener,
PropertyChangeListener {
    private static final Dimension H_SPACE_DIM = new Dimension(10, 5);
    private static final String NO_PHRASE_MSG = "Phrase not found.";
    private static final String OCCURENCES_MSG = " occurences found";
    private static final String OCCURENCE_MSG = " occurence found";
    private static final String DEFAULT = "No selected context";
    private static final String FIND_MSG = "Find in: ";
    private static final String RESULTS_MSG = "Results: ";
    static final String IN_ALL_MSG = "browser";
    private static final int WIDTH = 150;
    private JLabel titleLabel;
    private JPanel controlsPanel;
    private JTextField findArea;
    private JCheckBox caseSensitive;
    private JPanel treeHolderPanel;
    private JButton findNextButton;
    private JButton findPreviousButton;
    private FindResultsPane resultsPane;
    private FindPane model;
    private JScrollPane scrollPane;
    private JLabel resultMessage;

    private void initComponents() {
        this.findNextButton = new JButton(new FindNextAction(this.model));
        this.findPreviousButton = new JButton(new FindPreviousAction(this.model));
        this.titleLabel = new JLabel("Find in: No selected context");
        this.scrollPane = new JScrollPane();
        this.treeHolderPanel = new JPanel();
        this.resultMessage = new JLabel(RESULTS_MSG);
        this.treeHolderPanel.setBorder(new TitledBorder(RESULTS_MSG));
        this.caseSensitive = new JCheckBox("Match case");
        this.caseSensitive.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                FindPaneUI.this.model.setCaseSensitive(source.isSelected());
            }
        });
        this.findArea = new JTextField();
        this.findArea.setBorder(BorderFactory.createBevelBorder(1));
        this.findArea.setBackground(Color.WHITE);
        this.findArea.setOpaque(true);
        this.findArea.setEditable(true);
        int h = this.getFontMetrics(this.getFont()).getHeight() + 4;
        this.findArea.setPreferredSize(new Dimension(150, h));
        this.findArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                JTextField f;
                String text;
                Object source;
                if (e.getKeyCode() == 10 && (source = e.getSource()) instanceof JTextField && (text = (f = (JTextField)source).getText()) != null && text.trim().length() > 0) {
                    FindPaneUI.this.model.find();
                }
            }
        });
        this.findArea.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent de) {
                Document d = de.getDocument();
                try {
                    FindPaneUI.this.model.setTextUpdate(d.getText(0, d.getLength()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void removeUpdate(DocumentEvent de) {
                Document d = de.getDocument();
                try {
                    FindPaneUI.this.model.setTextUpdate(d.getText(0, d.getLength()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void changedUpdate(DocumentEvent de) {
            }
        });
    }

    private JToolBar createRightMenuBar() {
        JToolBar controlsBar = new JToolBar();
        controlsBar.setBorder(null);
        controlsBar.setRollover(true);
        controlsBar.setFloatable(false);
        controlsBar.add(this.findNextButton);
        controlsBar.add(this.findPreviousButton);
        FilterMenuAction action = new FilterMenuAction(this.model);
        JButton button = new JButton(action);
        button.addMouseListener(action);
        controlsBar.add(button);
        return controlsBar;
    }

    private JToolBar createLeftMenuBar() {
        JToolBar controlsBar = new JToolBar();
        controlsBar.setBorder(null);
        controlsBar.setRollover(true);
        controlsBar.setFloatable(false);
        JButton button = new JButton(new ClearAction(this.model));
        controlsBar.add(button);
        return controlsBar;
    }

    private void buildGUIHorizontalSplit() {
        GridBagConstraints c = new GridBagConstraints();
        this.treeHolderPanel = new JPanel();
        this.treeHolderPanel.setBorder(new TitledBorder(RESULTS_MSG));
        this.treeHolderPanel.setLayout(new BorderLayout());
        JPanel selectPanel = new JPanel();
        double[][] tl = new double[][]{{-2.0, 5.0, -2.0, -2.0, -2.0, -2.0}, {-2.0}};
        selectPanel.setLayout((LayoutManager)new TableLayout((double[][])tl));
        selectPanel.add((Component)this.createLeftMenuBar(), "0, 0");
        selectPanel.add(Box.createRigidArea(H_SPACE_DIM), "1, 0");
        selectPanel.add((Component)new JLabel("Find: "), "2, 0");
        selectPanel.add((Component)this.findArea, "3, 0");
        selectPanel.add((Component)this.createRightMenuBar(), "4, 0");
        selectPanel.add((Component)this.caseSensitive, "5, 0");
        this.titleLabel = new JLabel("Find in: No selected context");
        this.controlsPanel = new JPanel();
        this.controlsPanel.setLayout(new GridBagLayout());
        c.anchor = 18;
        c.fill = 0;
        c.gridy = 1;
        this.controlsPanel.add((Component)this.titleLabel, c);
        c.gridy = 2;
        c.weighty = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 0, 5, 10);
        this.controlsPanel.add((Component)new JSeparator(), c);
        c.ipadx = 0;
        c.gridy = 3;
        this.controlsPanel.add((Component)selectPanel, c);
        c.insets = new Insets(0, 0, 0, 0);
        this.setLayout(new GridBagLayout());
        c.anchor = 18;
        c.fill = 0;
        c.weightx = 0.1;
        c.weighty = 0.5;
        this.add((Component)this.controlsPanel, c);
        c.weightx = 100.0;
        c.fill = 1;
        this.add((Component)this.treeHolderPanel, c);
    }

    private void buildGUIVerticalSplit() {
        JPanel rowOne = new JPanel();
        rowOne.add(this.createLeftMenuBar());
        rowOne.add(Box.createRigidArea(H_SPACE_DIM));
        rowOne.add(new JLabel("Find: "));
        rowOne.add(this.findArea);
        JPanel rowTwo = new JPanel();
        rowTwo.add(this.createRightMenuBar());
        rowTwo.add(this.caseSensitive);
        JPanel rows = new JPanel();
        rows.setLayout(new BoxLayout(rows, 1));
        rows.add(UIUtilities.buildComponentPanel(rowOne));
        rows.add(rowTwo);
        this.titleLabel = new JLabel("Find in: No selected context");
        double[][] tl = new double[][]{{-1.0}, {-2.0, 5.0, -2.0, -2.0, 5.0, 300.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])tl));
        this.add((Component)UIUtilities.buildComponentPanel(this.titleLabel), "0, 0, f, t");
        this.add((Component)new JSeparator(), "0, 1, f, t");
        this.add((Component)UIUtilities.buildComponentPanel(rows), "0, 2, f, t");
        this.add((Component)UIUtilities.buildComponentPanel(this.resultMessage), "0, 3, f, t");
        this.add((Component)new JSeparator(), "0, 4, f, t");
        this.add((Component)this.scrollPane, "0, 5");
    }

    private void buildGUI() {
        this.buildGUIHorizontalSplit();
    }

    private void setMessage(int n) {
        String s = RESULTS_MSG;
        if (n == 0) {
            s = s + NO_PHRASE_MSG;
        } else if (n > 0) {
            s = n > 1 ? s + n + OCCURENCES_MSG : s + n + OCCURENCE_MSG;
        }
        this.resultMessage.setText(s);
        this.treeHolderPanel.setBorder(new TitledBorder(s));
    }

    FindPaneUI(FindPane model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.initComponents();
        this.buildGUI();
        this.onSelectedDisplay(true, IN_ALL_MSG);
    }

    void clear() {
        this.setMessage(-1);
        this.findArea.setText("");
        this.treeHolderPanel.removeAll();
        this.treeHolderPanel.repaint();
    }

    void onSelectedDisplay(boolean findText, String context) {
        this.findArea.setEditable(findText);
        if (context == null) {
            this.titleLabel.setText("Find in: No selected context");
        } else {
            this.titleLabel.setText(FIND_MSG + context);
        }
    }

    void setFoundResults(List results) {
        this.onFoundOccurences(results.size());
        this.resultsPane = new FindResultsPane(this.model, results);
        this.setMessage(this.resultsPane.getSizeResults());
        this.scrollPane.getViewport().add(this.resultsPane);
        this.treeHolderPanel.removeAll();
        this.treeHolderPanel.add((Component)this.scrollPane, "Center");
        this.treeHolderPanel.revalidate();
        this.revalidate();
    }

    void findNext() {
        if (this.resultsPane != null) {
            this.resultsPane.findNext();
        }
    }

    void findPrevious() {
        if (this.resultsPane != null) {
            this.resultsPane.findPrevious();
        }
    }

    void onTextSelected() {
        boolean b = this.model.isTextEmpty();
        this.findPreviousButton.setEnabled(b);
        this.findNextButton.setEnabled(b);
    }

    void onLevelChanged() {
        boolean b = true;
        if (!this.model.isNameSelected() && !this.model.isDescriptionSelected()) {
            b = false;
        }
        this.findPreviousButton.setEnabled(b);
        this.findNextButton.setEnabled(b);
    }

    void onFoundOccurences(int n) {
        this.findPreviousButton.setEnabled(n != 0);
        this.findNextButton.setEnabled(n != 0);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.findArea.setText((String)evt.getNewValue());
    }

    public void mousePressed(MouseEvent e) {
        Object[] h;
        if (this.findArea.getDocument().getLength() == 0 && (h = this.model.getHistory()).length != 0) {
            Rectangle r = this.findArea.getBounds();
            HistoryDialog d = new HistoryDialog(h, r.width);
            d.show(this.findArea, 0, r.height);
            d.addPropertyChangeListener("selection", this);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

