/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openmicroscopy.shoola.agents.hiviewer.HiViewerAgent;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoard;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoardPane;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder.FindData;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder.FindPaneUI;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder.FindPopupMenu;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.RegExFactory;

public class FindPane
extends ClipBoardPane {
    public static final String SELECTED_PROPERTY = "selected";
    private boolean caseSensitive;
    private String findText;
    private FindData findData;
    private FindPaneUI uiDelegate;
    private FindPopupMenu popupMenu;
    private List<String> history = new ArrayList<String>();
    private DefaultMutableTreeNode selectedNode;
    private boolean found = false;

    public FindPane(ClipBoard model) {
        super(model);
        this.findData = new FindData();
        this.uiDelegate = new FindPaneUI(this);
        this.popupMenu = new FindPopupMenu(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.add((Component)this.uiDelegate, c);
    }

    void setCaseSensitive(boolean b) {
        this.found = false;
        this.uiDelegate.onLevelChanged();
        this.caseSensitive = b;
    }

    void setNameSelected(boolean b) {
        this.found = false;
        this.uiDelegate.onLevelChanged();
        this.findData.nameSelected = b;
    }

    boolean isNameSelected() {
        return this.findData.nameSelected;
    }

    boolean isDescriptionSelected() {
        return this.findData.descriptionSelected;
    }

    void setDescriptionSelected(boolean b) {
        this.found = false;
        this.uiDelegate.onLevelChanged();
        this.findData.descriptionSelected = b;
    }

    boolean isTextEmpty() {
        if (this.findText == null) {
            return true;
        }
        return this.findText.length() == 0;
    }

    void setTextUpdate(String text) {
        this.findText = text;
        this.found = false;
        this.uiDelegate.onTextSelected();
    }

    void showFindMenu(Component c, Point p) {
        if (c == null) {
            throw new IllegalArgumentException("No component.");
        }
        if (p == null) {
            throw new IllegalArgumentException("No point.");
        }
        this.popupMenu.show(c, p.x, p.y);
    }

    void find() {
        if (this.findText == null || this.findText.length() == 0) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Pattern p = this.caseSensitive ? RegExFactory.createPattern(this.findText) : RegExFactory.createCaseInsensitivePattern(this.findText);
            this.model.find(p, this.findData);
            this.found = true;
            this.history.add(this.findText);
        }
        catch (PatternSyntaxException pse) {
            UserNotifier un = HiViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Find", "The phrase contains non valid characters.");
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    void clear() {
        this.model.clear();
        this.uiDelegate.clear();
    }

    void showMenu(JComponent invoker, Point p, ImageDisplay node) {
        this.model.showMenu(invoker, p, node);
    }

    void setSelectedNode(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        if (node.equals(this.selectedNode)) {
            return;
        }
        Object uo = node.getUserObject();
        if (uo instanceof String) {
            return;
        }
        ImageDisplay newObject = (ImageDisplay)uo;
        ImageDisplay oldObject = null;
        if (this.selectedNode != null) {
            oldObject = (ImageDisplay)this.selectedNode.getUserObject();
        }
        this.selectedNode = node;
        this.firePropertyChange(SELECTED_PROPERTY, oldObject, newObject);
    }

    void findNext() {
        if (!this.found) {
            this.find();
        } else {
            this.uiDelegate.findNext();
        }
    }

    void findPrevious() {
        if (!this.found) {
            this.find();
        } else {
            this.uiDelegate.findPrevious();
        }
    }

    String[] getHistory() {
        return this.history.toArray(new String[this.history.size()]);
    }

    public void setResults(List foundNodes) {
        if (foundNodes == null) {
            this.uiDelegate.onFoundOccurences(0);
            return;
        }
        this.uiDelegate.setFoundResults(foundNodes);
    }

    public void onDisplayChange(ImageDisplay selectedDisplay) {
        if (this.model.getSelectedPaneIndex() != 2) {
            return;
        }
    }

    public String getPaneName() {
        return "Find";
    }

    public Icon getPaneIcon() {
        return IconManager.getInstance().getIcon(40);
    }

    public int getPaneIndex() {
        return 2;
    }

    public String getPaneDescription() {
        return "Find";
    }
}

