/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder.FindPane;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder.FindPaneAction;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class FilterMenuAction
extends FindPaneAction
implements MouseListener {
    private static final String DESCRIPTION = "Menu. Press (Shift) to keep the menu on screen when making selection.";
    private Point pressedPoint;

    FilterMenuAction(FindPane model) {
        super(model);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(IconManager.FILTER_MENU));
    }

    public void mousePressed(MouseEvent me) {
        this.pressedPoint = me.getPoint();
    }

    public void mouseReleased(MouseEvent me) {
        Object source = me.getSource();
        if (source instanceof Component && this.isEnabled()) {
            this.model.showFindMenu((Component)source, this.pressedPoint);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

