/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.clipboard.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.editor.EditorPane;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.editor.EditorPaneUI;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.PermissionData;

class PermissionPane
extends JPanel {
    private static final String OWNER = "Owner: ";
    private static final String GROUP = "Group: ";
    private static final String WORLD = "Others: ";
    private static final String READ = "Read";
    private static final String WRITE = "Write";
    private static final Dimension SMALL_V_SPACER_SIZE = new Dimension(1, 6);
    private EditorPane model;
    private EditorPaneUI view;

    private JPanel buildPermissions(final PermissionData permissions) {
        JPanel content = new JPanel();
        content.setLayout(new GridBagLayout());
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 3, 3, 3);
        boolean isOwner = this.model.isObjectOwner();
        JLabel label = UIUtilities.setTextFont(OWNER);
        JPanel p = new JPanel();
        JCheckBox box = new JCheckBox(READ);
        box.setSelected(permissions.isUserRead());
        box.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                permissions.setUserRead(source.isSelected());
                PermissionPane.this.view.setEdit(true);
            }
        });
        box.setEnabled(false);
        p.add(box);
        box = new JCheckBox(WRITE);
        box.setSelected(permissions.isUserWrite());
        box.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                permissions.setUserWrite(source.isSelected());
                PermissionPane.this.view.setEdit(true);
            }
        });
        box.setEnabled(false);
        p.add(box);
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        content.add((Component)label, c);
        label.setLabelFor(p);
        c.gridx = 1;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        content.add((Component)UIUtilities.buildComponentPanel(p), c);
        label = UIUtilities.setTextFont(GROUP);
        p = new JPanel();
        box = new JCheckBox(READ);
        box.setSelected(permissions.isGroupRead());
        box.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                permissions.setGroupRead(source.isSelected());
                PermissionPane.this.view.setEdit(true);
            }
        });
        box.setEnabled(false);
        p.add(box);
        box = new JCheckBox(WRITE);
        box.setSelected(permissions.isGroupWrite());
        box.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                permissions.setGroupWrite(source.isSelected());
                PermissionPane.this.view.setEdit(true);
            }
        });
        box.setEnabled(false);
        p.add(box);
        c.gridy = 1;
        c.gridx = 0;
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        content.add((Component)label, c);
        label.setLabelFor(p);
        c.gridx = 1;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        content.add((Component)UIUtilities.buildComponentPanel(p), c);
        label = UIUtilities.setTextFont(WORLD);
        p = new JPanel();
        box = new JCheckBox(READ);
        box.setSelected(permissions.isWorldRead());
        box.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                permissions.setWorldRead(source.isSelected());
                PermissionPane.this.view.setEdit(true);
            }
        });
        box.setEnabled(false);
        p.add(box);
        box = new JCheckBox(WRITE);
        box.setSelected(permissions.isWorldWrite());
        box.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                permissions.setWorldWrite(source.isSelected());
                PermissionPane.this.view.setEdit(true);
            }
        });
        box.setEnabled(false);
        p.add(box);
        c.gridy = 2;
        c.gridx = 0;
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        content.add((Component)label, c);
        label.setLabelFor(p);
        c.gridx = 1;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        content.add((Component)UIUtilities.buildComponentPanel(p), c);
        return content;
    }

    private JPanel buildContentPanel(Map details) {
        JPanel content = new JPanel();
        content.setLayout(new GridBagLayout());
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 3, 3, 3);
        Iterator i = details.keySet().iterator();
        while (i.hasNext()) {
            ++c.gridy;
            c.gridx = 0;
            String key = (String)i.next();
            String value = (String)details.get(key);
            JLabel label = UIUtilities.setTextFont(key);
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            content.add((Component)label, c);
            JTextField area = new JTextField(value);
            area.setEditable(false);
            area.setEnabled(false);
            label.setLabelFor(area);
            c.gridx = 1;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            content.add((Component)area, c);
        }
        return content;
    }

    private void buildGUI(Map details, PermissionData permission) {
        JPanel contentPanel = this.buildContentPanel(details);
        this.setLayout(new BorderLayout());
        this.setMaximumSize(contentPanel.getPreferredSize());
        this.setBorder(new EtchedBorder());
        this.add((Component)contentPanel, "North");
        if (permission != null) {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            p.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            p.add(new JSeparator());
            p.add(Box.createRigidArea(SMALL_V_SPACER_SIZE));
            p.add(this.buildPermissions(permission));
            p.add(Box.createVerticalGlue());
            this.add(p);
        }
    }

    PermissionPane(EditorPaneUI view, EditorPane model, Map details, PermissionData permission) {
        if (details == null) {
            throw new IllegalArgumentException("Visualization map cannot be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.view = view;
        this.buildGUI(details, permission);
    }
}

