/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.clipboard.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.editor.EditorPane;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.editor.PermissionPane;
import org.openmicroscopy.shoola.util.ui.MultilineLabel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.PermissionData;
import pojos.ProjectData;

class EditorPaneUI
extends JPanel {
    private static final String EMPTY_MSG = "The name cannot be empty.";
    private static final String PROPERTY = "Properties";
    private static final String PERMISSIONS = "Permissions";
    private EditorPane model;
    private JButton finishButton;
    private JLabel titleLabel;
    private JPanel permissionPanel;
    private DocumentListener nameAreaListener;
    private DocumentListener descriptionAreaListener;
    private boolean warning;
    private boolean edit;
    private JTabbedPane tabs;
    private JTextField nameArea;
    private JTextArea descriptionArea;
    private Font titleLabelDefaultfont;
    private String message;
    private String originalName;

    private void handleNameAreaInsert() {
        this.finishButton.setEnabled(true);
        this.edit = true;
        if (this.warning) {
            this.titleLabel.setFont(this.titleLabelDefaultfont);
            this.titleLabel.setText(this.message);
            this.titleLabel.repaint();
        }
        this.warning = false;
    }

    private void handleNameAreaRemove(int length) {
        if (length == 0) {
            this.warning = true;
            this.message = this.titleLabel.getText();
            this.finishButton.setEnabled(false);
            this.titleLabel.setFont(this.titleLabelDefaultfont.deriveFont(1));
            this.titleLabel.setText(EMPTY_MSG);
            this.titleLabel.repaint();
        } else {
            this.finishButton.setEnabled(true);
        }
    }

    private void handleDescriptionAreaInsert() {
        this.finishButton.setEnabled(true);
        this.edit = true;
    }

    private void setTextAreaDefault(JTextComponent area) {
        area.setBorder(BorderFactory.createBevelBorder(1));
        area.setForeground(UIUtilities.STEELBLUE);
        area.setBackground(Color.WHITE);
        area.setOpaque(true);
        area.setEditable(true);
        area.setEnabled(false);
    }

    private void initComponents() {
        this.titleLabel = new JLabel(this.getMessage(null));
        this.titleLabelDefaultfont = this.titleLabel.getFont();
        this.finishButton = new JButton("Save");
        this.finishButton.setEnabled(false);
        this.finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorPaneUI.this.model.finish();
            }
        });
        this.nameArea = new JTextField();
        this.setTextAreaDefault(this.nameArea);
        this.descriptionArea = new MultilineLabel();
        this.setTextAreaDefault(this.descriptionArea);
        this.nameAreaListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent de) {
                EditorPaneUI.this.handleNameAreaInsert();
            }

            public void removeUpdate(DocumentEvent de) {
                EditorPaneUI.this.handleNameAreaRemove(de.getDocument().getLength());
            }

            public void changedUpdate(DocumentEvent de) {
            }
        };
        this.nameArea.getDocument().addDocumentListener(this.nameAreaListener);
        this.descriptionAreaListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent de) {
                EditorPaneUI.this.handleDescriptionAreaInsert();
            }

            public void removeUpdate(DocumentEvent de) {
                EditorPaneUI.this.handleDescriptionAreaInsert();
            }

            public void changedUpdate(DocumentEvent de) {
            }
        };
        this.descriptionArea.getDocument().addDocumentListener(this.descriptionAreaListener);
    }

    private JPanel buildContentPanel() {
        JPanel content = new JPanel();
        double[][] tl = new double[][]{{-2.0, -1.0}, {-2.0, 5.0, 0.0, 100.0}};
        TableLayout layout = new TableLayout((double[][])tl);
        content.setLayout((LayoutManager)layout);
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        content.add((Component)UIUtilities.setTextFont("Name"), "0, 0, l, c");
        content.add((Component)this.nameArea, "1, 0, f, c");
        content.add((Component)new JLabel(), "0, 1, 1, 1");
        JLabel l = UIUtilities.setTextFont("Description");
        layout.setRow(2, (double)(l.getFontMetrics(l.getFont()).getHeight() + 5));
        content.add((Component)l, "0, 2, l, c");
        JScrollPane pane = new JScrollPane(this.descriptionArea);
        content.add((Component)pane, "1, 2, 1, 3");
        return content;
    }

    private JPanel builPermissionPanel() {
        this.permissionPanel = new JPanel();
        this.permissionPanel.setLayout(new BorderLayout());
        return this.permissionPanel;
    }

    private void buildGUI() {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.titleLabel);
        p.add(this.finishButton);
        this.add((Component)UIUtilities.buildComponentPanel(p), "North");
        this.tabs = new JTabbedPane();
        this.tabs.addTab(PROPERTY, null, this.buildContentPanel());
        this.tabs.addTab(PERMISSIONS, null, this.builPermissionPanel());
        this.add((Component)this.tabs, "Center");
    }

    EditorPaneUI(EditorPane model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    String getMessage(DataObject ho) {
        if (ho instanceof ProjectData) {
            return "Edit project: " + ((ProjectData)ho).getName();
        }
        if (ho instanceof DatasetData) {
            return "Edit dataset: " + ((DatasetData)ho).getName();
        }
        if (ho instanceof CategoryGroupData) {
            return "Edit category group: " + ((CategoryGroupData)ho).getName();
        }
        if (ho instanceof CategoryData) {
            return "Edit category: " + ((CategoryData)ho).getName();
        }
        if (ho instanceof ImageData) {
            return "Edit image: " + ((ImageData)ho).getName();
        }
        return "No object to edit";
    }

    void setAreas(String name, String description, String title, boolean isWritable) {
        this.originalName = name;
        this.nameArea.setEnabled(isWritable);
        this.nameArea.getDocument().removeDocumentListener(this.nameAreaListener);
        this.nameArea.setText(name);
        this.nameArea.getDocument().addDocumentListener(this.nameAreaListener);
        this.descriptionArea.setEnabled(isWritable);
        this.descriptionArea.getDocument().removeDocumentListener(this.descriptionAreaListener);
        this.descriptionArea.setText(description);
        this.descriptionArea.getDocument().addDocumentListener(this.descriptionAreaListener);
        this.tabs.setVisible(!name.equals(""));
        this.finishButton.setEnabled(!name.equals(""));
        if (!isWritable) {
            this.finishButton.setEnabled(false);
        }
        this.titleLabel.setText(title);
    }

    void displayDetails(Map details, PermissionData permission) {
        this.permissionPanel.removeAll();
        if (details != null) {
            this.permissionPanel.add((Component)new PermissionPane(this, this.model, details, permission), "North");
        }
        this.permissionPanel.validate();
        this.permissionPanel.repaint();
    }

    String getObjectName() {
        return this.nameArea.getText();
    }

    String getObjectDescription() {
        return this.descriptionArea.getText();
    }

    boolean isEdit() {
        return this.edit;
    }

    void setEdit(boolean edit) {
        this.edit = edit;
    }

    void resetName() {
        this.nameArea.getDocument().removeDocumentListener(this.nameAreaListener);
        this.nameArea.setText(this.originalName);
        this.nameArea.getDocument().addDocumentListener(this.nameAreaListener);
    }

    void save() {
        this.finishButton.setEnabled(false);
    }
}

