/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.clipboard.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.Icon;
import org.openmicroscopy.shoola.agents.hiviewer.HiViewerAgent;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoard;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoardPane;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.editor.EditorPaneUI;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.editor.EditorPaneUtil;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.ProjectData;

public class EditorPane
extends ClipBoardPane {
    private EditorPaneUI uiDelegate = new EditorPaneUI(this);
    private boolean objectOwner;

    private DataObject fillDataObject() {
        Object hierarchyObject = this.model.getHierarchyObject();
        if (hierarchyObject instanceof ProjectData) {
            ProjectData data = (ProjectData)hierarchyObject;
            data.setName(this.uiDelegate.getObjectName());
            data.setDescription(this.uiDelegate.getObjectDescription());
            return data;
        }
        if (hierarchyObject instanceof DatasetData) {
            DatasetData data = (DatasetData)hierarchyObject;
            data.setName(this.uiDelegate.getObjectName());
            data.setDescription(this.uiDelegate.getObjectDescription());
            return data;
        }
        if (hierarchyObject instanceof CategoryData) {
            CategoryData data = (CategoryData)hierarchyObject;
            data.setName(this.uiDelegate.getObjectName());
            data.setDescription(this.uiDelegate.getObjectDescription());
            return data;
        }
        if (hierarchyObject instanceof CategoryGroupData) {
            CategoryGroupData data = (CategoryGroupData)hierarchyObject;
            data.setName(this.uiDelegate.getObjectName());
            data.setDescription(this.uiDelegate.getObjectDescription());
            return data;
        }
        if (hierarchyObject instanceof ImageData) {
            ImageData data = (ImageData)hierarchyObject;
            data.setName(this.uiDelegate.getObjectName());
            data.setDescription(this.uiDelegate.getObjectDescription());
            return data;
        }
        return null;
    }

    private ExperimenterData getDataObjectOwner(DataObject data) {
        ExperimenterData exp = data.getOwner();
        if (exp == null) {
            return null;
        }
        if (exp.isLoaded()) {
            return exp;
        }
        ExperimenterData selectedExp = this.model.getExperimenter();
        if (exp.getId() == selectedExp.getId()) {
            return selectedExp;
        }
        return exp;
    }

    public EditorPane(ClipBoard model) {
        super(model);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.add((Component)this.uiDelegate, c);
    }

    public void edit(Object ho) {
        if (ho == null || !(ho instanceof DataObject)) {
            this.uiDelegate.setAreas("", "", this.uiDelegate.getMessage(null), false);
            this.uiDelegate.displayDetails(null, null);
            return;
        }
        ExperimenterData user = this.model.getUserDetails();
        if (ho instanceof ImageData) {
            ImageData data = (ImageData)ho;
            this.uiDelegate.setAreas(data.getName(), data.getDescription(), this.uiDelegate.getMessage((DataObject)data), this.model.isObjectWritable((DataObject)data));
            ExperimenterData owner = this.getDataObjectOwner((DataObject)data);
            Map details = EditorPaneUtil.transformExperimenterData(owner);
            this.objectOwner = owner.getId() == user.getId();
            this.uiDelegate.displayDetails(details, data.getPermissions());
        } else if (ho instanceof DatasetData) {
            DatasetData data = (DatasetData)ho;
            this.uiDelegate.setAreas(data.getName(), data.getDescription(), this.uiDelegate.getMessage((DataObject)data), this.model.isObjectWritable((DataObject)data));
            ExperimenterData owner = this.getDataObjectOwner((DataObject)data);
            Map details = EditorPaneUtil.transformExperimenterData(owner);
            this.objectOwner = owner.getId() == user.getId();
            this.uiDelegate.displayDetails(details, data.getPermissions());
        } else if (ho instanceof ProjectData) {
            ProjectData data = (ProjectData)ho;
            this.uiDelegate.setAreas(data.getName(), data.getDescription(), this.uiDelegate.getMessage((DataObject)data), this.model.isObjectWritable((DataObject)data));
            ExperimenterData owner = this.getDataObjectOwner((DataObject)data);
            Map details = EditorPaneUtil.transformExperimenterData(owner);
            this.objectOwner = owner.getId() == user.getId();
            this.uiDelegate.displayDetails(details, data.getPermissions());
        } else if (ho instanceof CategoryGroupData) {
            CategoryGroupData data = (CategoryGroupData)ho;
            this.uiDelegate.setAreas(data.getName(), data.getDescription(), this.uiDelegate.getMessage((DataObject)data), this.model.isObjectWritable((DataObject)data));
            ExperimenterData owner = this.getDataObjectOwner((DataObject)data);
            Map details = EditorPaneUtil.transformExperimenterData(owner);
            this.objectOwner = owner.getId() == user.getId();
            this.uiDelegate.displayDetails(details, data.getPermissions());
        } else if (ho instanceof CategoryData) {
            CategoryData data = (CategoryData)ho;
            this.uiDelegate.setAreas(data.getName(), data.getDescription(), this.uiDelegate.getMessage((DataObject)data), this.model.isObjectWritable((DataObject)data));
            ExperimenterData owner = this.getDataObjectOwner((DataObject)data);
            Map details = EditorPaneUtil.transformExperimenterData(owner);
            this.objectOwner = owner.getId() == user.getId();
            this.uiDelegate.displayDetails(details, data.getPermissions());
        }
        this.uiDelegate.repaint();
    }

    public void onDisplayChange(ImageDisplay selectedDisplay) {
        this.objectOwner = false;
        if (this.model.getSelectedPaneIndex() != 3) {
            return;
        }
        if (selectedDisplay == null) {
            this.edit(null);
        } else {
            this.edit(selectedDisplay.getHierarchyObject());
        }
    }

    boolean isObjectOwner() {
        return this.objectOwner;
    }

    void finish() {
        if (!this.uiDelegate.isEdit()) {
            return;
        }
        String name = this.uiDelegate.getObjectName();
        if (name == null || name.length() == 0) {
            return;
        }
        DataObject object = this.fillDataObject();
        if (object == null) {
            return;
        }
        if (name.length() > 255) {
            UserNotifier un = HiViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Editor", "The name is too long. Cannot be more than 255 characters long.");
            this.uiDelegate.resetName();
            return;
        }
        this.uiDelegate.save();
        this.model.saveObject(object);
    }

    public String getPaneName() {
        return "Editor";
    }

    public Icon getPaneIcon() {
        return IconManager.getInstance().getIcon(6);
    }

    public int getPaneIndex() {
        return 3;
    }

    public String getPaneDescription() {
        return "Edit the selected object.";
    }
}

