/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.clipboard.clsf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultTreeModel;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.clsf.ClassificationPane;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheck;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheckNode;
import pojos.DataObject;

class ClassificationPaneUI
extends JPanel {
    private static final String PANEL_NOTE = "Categorisation for: ";
    private static final String PANEL_SUBNOTE = "Double click on the name to browse the group or the category.";
    private static final String NO_CLASSIFICATION_TEXT = "The selected item has not been categorised. ";
    private ClassificationPane model;
    private ViewerSorter sorter;
    private TreeCheck treeDisplay;
    private JLabel titleLabel;
    private JLabel noteLabel;
    private JButton declassifyButton;

    private void buildTreeNode(TreeCheckNode parent, List nodes) {
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        for (TreeCheckNode display : nodes) {
            tm.insertNodeInto(display, parent, parent.getChildCount());
            Set children = display.getChildrenDisplay();
            if (children.size() == 0) continue;
            this.buildTreeNode(display, this.sorter.sort(children));
        }
    }

    private void onClick(MouseEvent me) {
        Point p = me.getPoint();
        int row = this.treeDisplay.getRowForLocation(p.x, p.y);
        if (row != -1) {
            this.treeDisplay.setSelectionRow(row);
            if (me.getClickCount() != 2) {
                return;
            }
            Object node = this.treeDisplay.getLastSelectedPathComponent();
            if (!(node instanceof TreeCheckNode)) {
                return;
            }
            Object userObject = ((TreeCheckNode)node).getUserObject();
            if (userObject instanceof DataObject) {
                this.model.browse((DataObject)userObject);
            }
        }
    }

    private void initComponents() {
        this.declassifyButton = new JButton("Decategorise");
        this.declassifyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassificationPaneUI.this.model.declassify(ClassificationPaneUI.this.treeDisplay.getSelectedNodes());
            }
        });
        this.declassifyButton.setEnabled(false);
        this.titleLabel = new JLabel(NO_CLASSIFICATION_TEXT);
        this.noteLabel = new JLabel();
        IconManager im = IconManager.getInstance();
        this.treeDisplay = new TreeCheck("", im.getIcon(21));
        this.treeDisplay.setRootVisible(false);
        this.treeDisplay.setShowsRootHandles(true);
        this.treeDisplay.putClientProperty("JTree.lineStyle", "Angled");
        this.treeDisplay.getSelectionModel().setSelectionMode(1);
        this.treeDisplay.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ClassificationPaneUI.this.onClick(e);
            }

            public void mouseReleased(MouseEvent e) {
                ClassificationPaneUI.this.onClick(e);
            }
        });
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout(0, 0));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 1));
        titlePanel.add(this.titleLabel);
        titlePanel.add(this.noteLabel);
        p.add(UIUtilities.buildComponentPanel(titlePanel));
        p.add(UIUtilities.buildComponentPanel(this.declassifyButton));
        this.add((Component)UIUtilities.buildComponentPanel(p), "North");
        this.add((Component)new JScrollPane(this.treeDisplay), "Center");
    }

    ClassificationPaneUI(ClassificationPane model) {
        if (model == null) {
            throw new IllegalArgumentException("No Model.");
        }
        this.model = model;
        this.sorter = new ViewerSorter();
        this.initComponents();
        this.buildGUI();
    }

    void onSelectedDisplay(String title) {
        this.declassifyButton.setEnabled(false);
        if (title == null) {
            this.titleLabel.setText(NO_CLASSIFICATION_TEXT);
            this.noteLabel.setText("");
        } else {
            this.titleLabel.setText(PANEL_NOTE + title);
            this.noteLabel.setText(PANEL_SUBNOTE);
        }
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeCheckNode root = (TreeCheckNode)dtm.getRoot();
        root.removeAllChildren();
        root.removeAllChildrenDisplay();
        dtm.reload();
        this.repaint();
    }

    void showClassifications(Set nodes) {
        this.declassifyButton.setEnabled(nodes.size() != 0);
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeCheckNode root = (TreeCheckNode)dtm.getRoot();
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            root.addChildDisplay((TreeCheckNode)i.next());
        }
        this.buildTreeNode(root, this.sorter.sort(nodes));
        dtm.reload();
        dtm.reload();
    }
}

