/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.clipboard.clsf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Icon;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoard;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoardPane;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.clsf.ClassificationPaneUI;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheckNode;
import pojos.CategoryData;
import pojos.DataObject;
import pojos.ImageData;

public class ClassificationPane
extends ClipBoardPane {
    private ClassificationPaneUI uiDelegate = new ClassificationPaneUI(this);
    private ImageData image;

    public ClassificationPane(ClipBoard model) {
        super(model);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.add((Component)this.uiDelegate, c);
    }

    void browse(DataObject object) {
        if (object == null) {
            return;
        }
        this.model.browse(object);
    }

    void declassify(Set nodes) {
        if (nodes == null || nodes.size() == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Classification", "You first need to remove the categories to remove the image from.");
            return;
        }
        if (this.image == null) {
            return;
        }
        HashSet<Object> paths = new HashSet<Object>(nodes.size());
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            Object object = ((TreeCheckNode)i.next()).getUserObject();
            if (!(object instanceof CategoryData)) continue;
            paths.add(object);
        }
        this.model.declassifyImage(this.image, paths);
    }

    public void showClassifications(Set nodes) {
        if (nodes == null) {
            return;
        }
        this.uiDelegate.showClassifications(nodes);
    }

    public String getPaneName() {
        return "Categorisation";
    }

    public Icon getPaneIcon() {
        return IconManager.getInstance().getIcon(15);
    }

    public int getPaneIndex() {
        return 0;
    }

    public String getPaneDescription() {
        return "Display the categories containing the image.";
    }

    public void onDisplayChange(ImageDisplay selectedDisplay) {
        if (this.model.getSelectedPaneIndex() != 1) {
            return;
        }
        this.image = null;
        if (selectedDisplay == null) {
            this.uiDelegate.onSelectedDisplay(null);
            return;
        }
        Object ho = selectedDisplay.getHierarchyObject();
        if (ho == null) {
            this.uiDelegate.onSelectedDisplay(null);
            return;
        }
        String title = null;
        if (ho instanceof ImageData) {
            ImageData img = (ImageData)ho;
            Long n = img.getClassificationCount();
            if (n == null || n == 0L) {
                title = null;
            } else {
                this.image = img;
                title = img.getName();
                this.model.retrieveClassifications(img);
            }
        }
        this.uiDelegate.onSelectedDisplay(title);
    }
}

