/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.clipboard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoardModel;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.AnnotateCmd;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ClassifyCmd;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.PropertiesCmd;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ViewCmd;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.ProjectData;

class PopupMenu
extends JPopupMenu {
    private JMenuItem view;
    private JMenuItem classify;
    private JMenuItem declassify;
    private JMenuItem properties;
    private JMenuItem annotate;
    private ClipBoardModel model;
    private ImageDisplay selectedNode;

    private void initComponents() {
        IconManager im = IconManager.getInstance();
        this.properties = new JMenuItem("Properties", im.getIcon(6));
        this.properties.setToolTipText("Display the object properties.");
        this.properties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataObject object = PopupMenu.this.getDataObject();
                if (object != null) {
                    PropertiesCmd cmd = new PropertiesCmd(PopupMenu.this.model.getParentModel(), object);
                    cmd.execute();
                }
            }
        });
        this.annotate = new JMenuItem("Annotate", im.getIcon(8));
        this.annotate.setToolTipText("Annotate the selected image or dataset.");
        this.annotate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataObject object = PopupMenu.this.getDataObject();
                if (object != null) {
                    AnnotateCmd cmd = new AnnotateCmd(PopupMenu.this.model.getParentModel(), PopupMenu.this.selectedNode);
                    cmd.execute();
                }
            }
        });
        this.classify = new JMenuItem("Categorise", im.getIcon(25));
        this.classify.setToolTipText("Categorise the selected images.");
        this.classify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataObject object = PopupMenu.this.getDataObject();
                if (object instanceof ImageData) {
                    ClassifyCmd cmd = new ClassifyCmd(PopupMenu.this.model.getParentModel(), (ImageData)object, 0);
                    cmd.execute();
                }
            }
        });
        this.declassify = new JMenuItem("Decategorise", im.getIcon(IconManager.DECATEGORISE));
        this.declassify.setToolTipText("Decategorise the selected images.");
        this.declassify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataObject object = PopupMenu.this.getDataObject();
                if (object instanceof ImageData) {
                    ClassifyCmd cmd = new ClassifyCmd(PopupMenu.this.model.getParentModel(), (ImageData)object, 1);
                    cmd.execute();
                }
            }
        });
        this.view = new JMenuItem("Name", im.getIcon(7));
        this.view.setToolTipText("View the selected image.");
        this.view.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataObject object = PopupMenu.this.getDataObject();
                if (object != null) {
                    ViewCmd cmd = new ViewCmd(PopupMenu.this.model.getParentModel(), object);
                    cmd.execute();
                }
            }
        });
    }

    private DataObject getDataObject() {
        DataObject target = null;
        if (this.selectedNode != null) {
            Object hierarchyObj = this.selectedNode.getHierarchyObject();
            if (hierarchyObj == null) {
                return null;
            }
            if (hierarchyObj instanceof ProjectData || hierarchyObj instanceof DatasetData || hierarchyObj instanceof ImageData || hierarchyObj instanceof CategoryData || hierarchyObj instanceof CategoryGroupData) {
                target = (DataObject)hierarchyObj;
            }
        }
        return target;
    }

    private void buildGUI() {
        this.add(this.view);
        this.add(new JSeparator(0));
        this.add(this.classify);
        this.add(this.declassify);
        this.add(this.annotate);
        this.add(new JSeparator(0));
        this.add(this.properties);
    }

    PopupMenu(ClipBoardModel model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    void showMenuFor(JComponent invoker, int x, int y, ImageDisplay node) {
        if (node == null) {
            return;
        }
        this.selectedNode = node;
        DataObject object = this.getDataObject();
        if (object == null) {
            return;
        }
        String txt = "Browse";
        String toolTip = "Browse the selected project, dataset, categoryGroup or category";
        boolean b = false;
        if (object instanceof ImageData) {
            txt = "View";
            toolTip = "View the selected image.";
            b = true;
        }
        this.view.setText(txt);
        this.view.setToolTipText(toolTip);
        this.classify.setEnabled(b);
        this.declassify.setEnabled(b);
        this.show(invoker, x, y);
    }
}

