/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.clipboard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoardControl;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoardModel;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoardPane;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.PopupMenu;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.clsf.ClassificationPane;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder.FindPane;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.info.InfoPane;
import pojos.ImageData;

class ClipBoardUI
extends JTabbedPane {
    private ClipBoardControl controller;
    private ClipBoardModel model;
    private PopupMenu popupMenu;

    private void initComponents() {
        this.popupMenu = new PopupMenu(this.model);
    }

    private void buildUI() {
        int h = 0;
        Dimension dim = this.model.getComponentPreferredSize();
        ClipBoardPane pane = this.model.getClipboardPane(0);
        Icon icon = pane.getPaneIcon();
        if (icon != null && icon.getIconHeight() > h) {
            h = icon.getIconHeight();
        }
        Component c = pane;
        c = pane.getComponent(0);
        this.insertTab(pane.getPaneName(), icon, c, pane.getPaneDescription(), 0);
        pane = this.model.getClipboardPane(1);
        icon = pane.getPaneIcon();
        if (icon != null && icon.getIconHeight() > h) {
            h = icon.getIconHeight();
        }
        this.insertTab(pane.getPaneName(), icon, pane, pane.getPaneDescription(), 1);
        pane = this.model.getClipboardPane(2);
        icon = pane.getPaneIcon();
        if (icon != null && icon.getIconHeight() > h) {
            h = icon.getIconHeight();
        }
        this.insertTab(pane.getPaneName(), icon, pane, pane.getPaneDescription(), 2);
        pane = this.model.getClipboardPane(3);
        icon = pane.getPaneIcon();
        if (icon != null && icon.getIconHeight() > h) {
            h = icon.getIconHeight();
        }
        this.insertTab(pane.getPaneName(), icon, pane, pane.getPaneDescription(), 3);
        pane = this.model.getClipboardPane(4);
        icon = pane.getPaneIcon();
        if (icon != null && icon.getIconHeight() > h) {
            h = icon.getIconHeight();
        }
        this.insertTab(pane.getPaneName(), icon, pane, pane.getPaneDescription(), 4);
        this.setSelectedIndex(this.model.getPaneIndex());
        Dimension d = new Dimension(dim.width, h + 10);
        this.setPreferredSize(d);
        this.setMinimumSize(new Dimension(5, h));
    }

    ClipBoardUI() {
        super(1, 0);
        this.setAlignmentX(0.0f);
    }

    void initialize(ClipBoardModel model, ClipBoardControl controller) {
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = controller;
        this.initComponents();
        this.buildUI();
    }

    void initListeners() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                ClipBoardUI.this.controller.removeRollOver();
            }
        });
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                switch (ClipBoardUI.this.getSelectedIndex()) {
                    case 2: {
                        ClipBoardUI.this.controller.setSelectedPane(2);
                        break;
                    }
                    case 0: {
                        ClipBoardUI.this.controller.setSelectedPane(0);
                        break;
                    }
                    case 4: {
                        ClipBoardUI.this.controller.setSelectedPane(4);
                        break;
                    }
                    case 3: {
                        ClipBoardUI.this.controller.setSelectedPane(3);
                        break;
                    }
                    case 1: {
                        ClipBoardUI.this.controller.setSelectedPane(1);
                    }
                }
            }
        });
        ClipBoardPane pane = this.model.getClipboardPane(2);
        pane.addPropertyChangeListener("selected", this.controller);
        Map m = this.model.getClipBoardPanes();
        Iterator i = m.keySet().iterator();
        while (i.hasNext()) {
            pane = (ClipBoardPane)m.get(i.next());
            pane.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    ClipBoardUI.this.controller.removeRollOver();
                }
            });
        }
    }

    void setSearchResults(List foundNodes) {
        FindPane pane = (FindPane)this.model.getClipboardPane(2);
        pane.setResults(foundNodes);
    }

    void onDisplayChange(ImageDisplay selectedDisplay) {
        Map m = this.model.getClipBoardPanes();
        Iterator i = m.keySet().iterator();
        while (i.hasNext()) {
            ((ClipBoardPane)m.get(i.next())).onDisplayChange(selectedDisplay);
        }
    }

    int getTabPaneHeight() {
        return this.getHeight();
    }

    void setSelectedPane(int index) {
        this.setSelectedIndex(index);
    }

    void showMenu(JComponent invoker, Point p, ImageDisplay node) {
        this.popupMenu.showMenuFor(invoker, p.x, p.y, node);
    }

    void setChannelMetadata(List l, ImageData image) {
        if (this.model.getPaneIndex() != 4) {
            return;
        }
        InfoPane pane = (InfoPane)this.model.getClipboardPane(4);
        pane.setChannelsMetadata(l, image);
    }

    void showClassifications(Set paths) {
        if (this.model.getPaneIndex() != 1) {
            return;
        }
        ClassificationPane pane = (ClassificationPane)this.model.getClipboardPane(1);
        pane.showClassifications(paths);
    }
}

