/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.clipboard;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.hiviewer.CBDataLoader;
import org.openmicroscopy.shoola.agents.hiviewer.ChannelMetadataLoader;
import org.openmicroscopy.shoola.agents.hiviewer.ClassificationsLoader;
import org.openmicroscopy.shoola.agents.hiviewer.Declassifier;
import org.openmicroscopy.shoola.agents.hiviewer.HiViewerAgent;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.AnnotationPane;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoardComponent;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoardPane;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.clsf.ClassificationPane;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.editor.EditorPane;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder.FindPane;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.info.InfoPane;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorEditor;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorFactory;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.ImageData;

class ClipBoardModel {
    private int state;
    private HiViewer parentModel;
    private int paneIndex;
    private Set classifications;
    private ViewerSorter sorter;
    private CBDataLoader currentLoader;
    private HashMap<Integer, ClipBoardPane> cbPanes;
    private boolean display;
    protected ClipBoardComponent component;

    private void init() {
        this.setPaneIndex(0);
        this.cbPanes = new HashMap();
        this.sorter = new ViewerSorter();
        this.sorter.setAscending(false);
    }

    private void createClipBoardPanes() {
        this.cbPanes.put(new Integer(2), new FindPane(this.component));
        int layout = 0;
        AnnotatorEditor annotator = AnnotatorFactory.getEditor(HiViewerAgent.getRegistry(), null, layout);
        this.cbPanes.put(new Integer(0), new AnnotationPane(this.component, annotator));
        this.cbPanes.put(new Integer(4), new InfoPane(this.component));
        this.cbPanes.put(new Integer(3), new EditorPane(this.component));
        this.cbPanes.put(new Integer(1), new ClassificationPane(this.component));
    }

    ClipBoardModel(HiViewer parentModel) {
        if (parentModel == null) {
            throw new NullPointerException("No parent model.");
        }
        this.parentModel = parentModel;
        this.init();
    }

    void initialize(ClipBoardComponent component) {
        if (component == null) {
            throw new NullPointerException("No component");
        }
        this.component = component;
        this.createClipBoardPanes();
    }

    ClipBoardPane getClipboardPane(int index) {
        return this.cbPanes.get(new Integer(index));
    }

    Map getClipBoardPanes() {
        return this.cbPanes;
    }

    HiViewer getParentModel() {
        return this.parentModel;
    }

    int getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = state;
    }

    int getPaneIndex() {
        return this.paneIndex;
    }

    void setPaneIndex(int i) {
        this.paneIndex = i;
    }

    ExperimenterData getUserDetails() {
        return this.parentModel.getUserDetails();
    }

    void fireClassificationsLoading(ImageData ho) {
        this.currentLoader = new ClassificationsLoader(this.component, ho.getId(), this.parentModel.getRootID());
        this.currentLoader.load();
        this.state = 200;
    }

    void fireAnnotationsLoading(DataObject ho) {
    }

    long getUserID() {
        return this.parentModel.getUserDetails().getId();
    }

    long getGroupID() {
        return this.parentModel.getRootID();
    }

    void fireChannelsMetadataLoading(ImageData img) {
        this.currentLoader = new ChannelMetadataLoader(this.component, img);
        this.currentLoader.load();
        this.state = 199;
    }

    void setDisplay(boolean b) {
        this.display = b;
    }

    boolean isDisplay() {
        return this.display;
    }

    void setClassifications(Set classifications) {
        this.classifications = classifications;
        this.state = 201;
    }

    void declassifyImage(ImageData image, Set paths) {
        this.currentLoader = new Declassifier(this.component, image, paths);
        this.currentLoader.load();
        this.state = 202;
    }

    Dimension getComponentPreferredSize() {
        Dimension d = this.parentModel.getBrowser().getUI().getPreferredSize();
        return new Dimension(d.width - 10, d.height);
    }
}

