/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.clipboard;

import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.AnnotationPane;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoard;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoardModel;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoardUI;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import pojos.DataObject;

class ClipBoardControl
implements ChangeListener,
PropertyChangeListener {
    private static final String LOADING_MSG = "Loading...";
    private ClipBoardUI view;
    private ClipBoardModel model;
    private ClipBoard component;

    ClipBoardControl(ClipBoard component) {
        if (component == null) {
            throw new NullPointerException("No component.");
        }
        this.component = component;
    }

    void initialize(ClipBoardUI view, ClipBoardModel model) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.view = view;
        this.model = model;
        this.component.addChangeListener(this);
        view.initListeners();
        model.getParentModel().addChangeListener(this);
        AnnotationPane pane = (AnnotationPane)model.getClipboardPane(0);
        pane.registerListener(this);
    }

    void setSelectedPane(int index) {
        this.component.setSelectedPane(index, null);
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String name = pce.getPropertyName();
        if (name.equals("selectedDisplay")) {
            Browser browser = this.model.getParentModel().getBrowser();
            if (browser != null) {
                ImageDisplay node = browser.getLastSelectedDisplay();
                this.view.onDisplayChange(node);
            }
        } else if (name.equals("selected")) {
            Browser browser = this.model.getParentModel().getBrowser();
            if (browser != null) {
                ImageDisplay node = (ImageDisplay)pce.getNewValue();
                browser.setSelectedDisplay(node);
                this.model.getParentModel().scrollToNode(node);
            }
        } else if (name.equals("mouseOver")) {
            Object n = pce.getNewValue();
            if (n instanceof ImageDisplay) {
                this.view.onDisplayChange((ImageDisplay)n);
            } else {
                this.view.onDisplayChange(null);
            }
        } else if ("annotated".equals(name)) {
            DataObject object = (DataObject)pce.getNewValue();
            AnnotationPane p = (AnnotationPane)this.model.getClipboardPane(0);
            if (object == null) {
                p.retrieveAnnotation(object);
            }
            this.view.setCursor(Cursor.getPredefinedCursor(0));
            ArrayList<DataObject> l = new ArrayList<DataObject>(1);
            l.add(object);
            this.model.getParentModel().onDataObjectSave(l);
            p.retrieveAnnotation(object);
        }
    }

    public void stateChanged(ChangeEvent ce) {
        Object source = ce.getSource();
        if (source instanceof HiViewer) {
            HiViewer parentModel = this.model.getParentModel();
            if (parentModel.getState() == 5) {
                parentModel.getBrowser().addPropertyChangeListener("selectedDisplay", this);
                parentModel.getBrowser().addPropertyChangeListener("mouseOver", this);
            }
        } else if (source instanceof ClipBoard) {
            switch (this.model.getState()) {
                case 199: 
                case 200: {
                    this.model.getParentModel().setStatus(LOADING_MSG, -1);
                    break;
                }
                case 198: 
                case 201: {
                    this.model.getParentModel().setStatus("", -1);
                }
            }
        }
    }

    void removeRollOver() {
        this.component.removeRollOver();
    }
}

