/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.clipboard;

import java.awt.Point;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.agents.hiviewer.HiTranslator;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoard;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoardControl;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoardModel;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoardUI;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.editor.EditorPane;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.finder.FindData;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ClearCmd;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.FindRegExCmd;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ViewCmd;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.ImageData;

class ClipBoardComponent
extends AbstractComponent
implements ClipBoard {
    private ClipBoardModel model;
    private ClipBoardUI view;
    private ClipBoardControl controller;

    ClipBoardComponent(ClipBoardModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new ClipBoardControl(this);
        this.view = new ClipBoardUI();
    }

    void initialize() {
        this.model.initialize(this);
        this.view.initialize(this.model, this.controller);
        this.controller.initialize(this.view, this.model);
    }

    public JComponent getUI() {
        return this.view;
    }

    public void setFoundResults(List foundNodes) {
        this.view.setSearchResults(foundNodes);
    }

    public void discard() {
    }

    public void setSelectedPane(int index, ImageDisplay node) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Pane index not valid.");
            }
        }
        if (this.model.getPaneIndex() == index) {
            return;
        }
        this.model.setPaneIndex(index);
        this.view.setSelectedPane(index);
        if (node == null) {
            this.view.onDisplayChange(this.model.getParentModel().getBrowser().getLastSelectedDisplay());
        }
    }

    public int getState() {
        return this.model.getState();
    }

    public void showMenu(JComponent invoker, Point p, ImageDisplay node) {
        if (node == null) {
            throw new IllegalArgumentException("No node");
        }
        if (invoker == null) {
            throw new IllegalArgumentException("No invoker");
        }
        if (p == null) {
            throw new IllegalArgumentException("No point.");
        }
        this.view.showMenu(invoker, p, node);
    }

    public int getSelectedPaneIndex() {
        return this.model.getPaneIndex();
    }

    public ExperimenterData getUserDetails() {
        return this.model.getUserDetails();
    }

    public void clear() {
        ClearCmd cmd = new ClearCmd(this.model.getParentModel());
        cmd.execute();
    }

    public void find(Pattern p, FindData context) {
        if (p == null) {
            throw new IllegalArgumentException("No pattern.");
        }
        if (context == null) {
            throw new IllegalArgumentException("No context");
        }
        FindRegExCmd cmd = new FindRegExCmd(this.model.getParentModel(), p, context);
        cmd.execute();
    }

    public Object getHierarchyObject() {
        return this.model.getParentModel().getHierarchyObject();
    }

    public boolean isObjectWritable(DataObject ho) {
        return this.model.getParentModel().isObjectWritable(ho);
    }

    public void saveObject(DataObject object) {
        if (object == null) {
            throw new IllegalArgumentException("No object to save.");
        }
        this.model.getParentModel().saveObject(object);
    }

    public void showProperties(DataObject object) {
        if (object == null) {
            throw new IllegalArgumentException("No object to edit.");
        }
        if (this.model.getPaneIndex() != 3) {
            this.model.setPaneIndex(3);
            this.view.setSelectedPane(3);
        }
        EditorPane pane = (EditorPane)this.model.getClipboardPane(3);
        pane.edit(object);
    }

    public void retrieveChannelsMetadata(ImageData img) {
        this.model.fireChannelsMetadataLoading(img);
        this.fireStateChange();
    }

    public void setChannelsMetadata(List list, ImageData image) {
        if (this.model.getState() != 199) {
            return;
        }
        this.model.setState(198);
        this.view.setChannelMetadata(list, image);
        this.fireStateChange();
    }

    public void setDisplay(boolean b) {
        this.model.setDisplay(b);
    }

    public boolean isDisplay() {
        return this.model.isDisplay();
    }

    public void browse(DataObject object) {
        if (object == null) {
            return;
        }
        ViewCmd cmd = new ViewCmd(this.model.getParentModel(), object);
        cmd.execute();
    }

    public void retrieveClassifications(ImageData object) {
        if (object == null) {
            return;
        }
        this.model.fireClassificationsLoading(object);
        this.fireStateChange();
    }

    public void setClassifications(Set nodes) {
        if (this.model.getState() != 200) {
            return;
        }
        Set paths = HiTranslator.transformClassificationPaths(nodes, this.model.getUserID(), this.model.getGroupID());
        this.model.setClassifications(paths);
        this.view.showClassifications(paths);
        this.fireStateChange();
    }

    public void declassifyImage(ImageData image, Set paths) {
        if (this.model.getState() != 201) {
            return;
        }
        if (image == null || paths == null) {
            return;
        }
        this.model.declassifyImage(image, paths);
        this.fireStateChange();
    }

    public void onClassificationChange(List imageNodes) {
        if (this.model.getState() != 202) {
            return;
        }
        this.model.getParentModel().onDataObjectSave(imageNodes);
    }

    public void removeRollOver() {
        this.firePropertyChange("removeNodeRollOver", Boolean.FALSE, Boolean.TRUE);
    }

    public ExperimenterData getExperimenter() {
        return this.model.getParentModel().getExperimenter();
    }
}

