/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.clipboard;

import java.awt.FlowLayout;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoard;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoardPane;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorEditor;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ImageData;

class AnnotationPane
extends ClipBoardPane {
    private AnnotatorEditor annotator;

    AnnotationPane(ClipBoard model, AnnotatorEditor annotator) {
        super(model);
        if (annotator == null) {
            throw new IllegalArgumentException("No annotator");
        }
        this.annotator = annotator;
        this.setLayout(new FlowLayout(0));
        this.add(annotator.getUI());
    }

    void registerListener(PropertyChangeListener listener) {
        this.annotator.addPropertyChangeListener(listener);
    }

    void retrieveAnnotation(DataObject ho) {
        this.annotator.retrieveAnnotations(ho);
    }

    public String getPaneName() {
        return "Annotation";
    }

    public Icon getPaneIcon() {
        return IconManager.getInstance().getIcon(8);
    }

    public int getPaneIndex() {
        return 0;
    }

    public String getPaneDescription() {
        return "Annotate the selected item.";
    }

    public void onDisplayChange(ImageDisplay selectedDisplay) {
        if (this.model.getSelectedPaneIndex() != 0) {
            return;
        }
        if (selectedDisplay == null) {
            this.annotator.retrieveAnnotations(null);
            return;
        }
        Object ho = selectedDisplay.getHierarchyObject();
        if (ho == null) {
            this.annotator.retrieveAnnotations(null);
            return;
        }
        if (ho instanceof ImageData || ho instanceof DatasetData) {
            this.annotator.retrieveAnnotations((DataObject)ho);
        } else {
            this.annotator.retrieveAnnotations(null);
        }
    }
}

