/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.browser;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;

class PinButton
extends JButton {
    private final String DESCRIPTION = "Click to pin the thumbnail on desktop.";
    private final ImageNode parentNode;

    PinButton(ImageNode node) {
        if (node == null) {
            throw new IllegalArgumentException("No node");
        }
        this.parentNode = node;
        this.setContentAreaFilled(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setOpaque(false);
        this.setFocusPainted(false);
        IconManager im = IconManager.getInstance();
        this.setIcon(im.getIcon(IconManager.PIN_SMALL));
        this.setToolTipText("Click to pin the thumbnail on desktop.");
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PinButton.this.parentNode.pinThumbnail();
            }
        });
    }
}

