/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.browser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import pojos.DatasetData;

public class ImageSet
extends ImageDisplay
implements PropertyChangeListener {
    protected Boolean containsImages;

    protected void doAccept(ImageDisplayVisitor visitor) {
        visitor.visit(this);
    }

    public ImageSet(String title, Object hierarchyObject) {
        this(title, "", hierarchyObject);
    }

    public ImageSet(String title, String note, Object hierarchyObject) {
        super(title, note, hierarchyObject);
        this.setResizable(true);
        if (hierarchyObject instanceof DatasetData) {
            this.addPropertyChangeListener("frameIconPressed", this);
        }
    }

    public void addChildDisplay(ImageDisplay child) {
        if (child == null) {
            throw new NullPointerException("No child.");
        }
        Class<?> childClass = child.getClass();
        if (this.containsImages == null) {
            this.containsImages = new Boolean(childClass.equals(ImageNode.class));
        } else if (this.containsImages.booleanValue()) {
            if (!childClass.equals(ImageNode.class)) {
                throw new IllegalArgumentException("This node can only contain ImageNodes.");
            }
        } else if (!childClass.equals(ImageSet.class)) {
            throw new IllegalArgumentException("This node can only contain ImageSets.");
        }
        super.addChildDisplay(child);
    }

    public boolean containsImages() {
        if (this.containsImages == null) {
            return false;
        }
        return this.containsImages;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.isAnnotated()) {
            this.fireAnnotation();
        }
    }
}

