/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.browser;

import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JButton;
import org.openmicroscopy.shoola.agents.hiviewer.browser.AnnotatedButton;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ClassifiedButton;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.hiviewer.browser.PinButton;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Thumbnail;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ThumbnailCanvas;
import pojos.ImageData;

public class ImageNode
extends ImageDisplay {
    public static final String CLASSIFY_NODE_PROPERTY = "classifyNode";
    public static final String PIN_THUMBNAIL_PROPERTY = "pinThumbnail";
    private static final String LEFT = " (";
    private static final String RIGHT = ")";
    private Thumbnail thumbnail;
    private ThumbnailCanvas canvas;

    protected void doAccept(ImageDisplayVisitor visitor) {
        visitor.visit(this);
    }

    void pinThumbnail() {
        this.firePropertyChange(PIN_THUMBNAIL_PROPERTY, null, this);
    }

    void addMouseListenerToComponents(MouseListener listener) {
        this.getTitleBar().addMouseListener(listener);
        this.addMouseListener(listener);
        this.canvas.addMouseListener(listener);
    }

    public ImageNode(String title, Object hierarchyObject, Thumbnail t) {
        super(title, "", hierarchyObject);
        this.setTitle(this.getPartialName(title + LEFT + this.getFormattedAcquisitionTime() + RIGHT));
        this.setNodeDecoration();
        this.setTitleBarType(1);
        if (t == null) {
            throw new NullPointerException("No thumbnail.");
        }
        this.thumbnail = t;
        this.canvas = new ThumbnailCanvas(this);
        this.getInternalDesktop().add(this.canvas);
        this.setCanvasSize(t.getWidth(), t.getHeight());
    }

    public void fireClassification() {
        this.firePropertyChange(CLASSIFY_NODE_PROPERTY, null, this);
    }

    public void setNodeDecoration() {
        if (this.hierarchyObject instanceof ImageData) {
            ArrayList<JButton> nodes = new ArrayList<JButton>();
            nodes.add(new PinButton(this));
            if (this.isAnnotated()) {
                nodes.add(new AnnotatedButton(this));
            }
            if (this.isClassified()) {
                nodes.add(new ClassifiedButton(this));
            }
            this.setDecoration(nodes);
        }
    }

    public boolean isClassified() {
        if (this.hierarchyObject instanceof ImageData) {
            ImageData d = (ImageData)this.hierarchyObject;
            Long n = d.getClassificationCount();
            return n != null && n > 0L;
        }
        return false;
    }

    public void addChildDisplay(ImageDisplay child) {
        throw new IllegalArgumentException("Can't add a child to an ImageNode.");
    }

    public boolean containsImages() {
        return false;
    }

    public Thumbnail getThumbnail() {
        return this.thumbnail;
    }

    public Timestamp getAcquisitionTime() {
        Timestamp t = null;
        try {
            t = ((ImageData)this.getHierarchyObject()).getInserted();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (t == null) {
            t = new Timestamp(new Date().getTime());
        }
        return t;
    }

    public String getFormattedAcquisitionTime() {
        return DateFormat.getDateInstance().format(this.getAcquisitionTime());
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.setResizable(false);
    }

    public void setCanvasSize(int w, int h) {
        this.canvas.setBounds(0, 0, w, h);
        this.getInternalDesktop().setSize(w, h);
        this.getInternalDesktop().setPreferredSize(new Dimension(w, h));
    }
}

