/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.browser;

import java.awt.Cursor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageSet;
import org.openmicroscopy.shoola.agents.hiviewer.tpane.TinyPane;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.ProjectData;

public abstract class ImageDisplay
extends TinyPane {
    public static final String ANNOTATE_NODE_PROPERTY = "annotateNode";
    protected ImageDisplay parentDisplay;
    private Set childrenDisplay;
    protected Object hierarchyObject;

    private boolean checkAlgoType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected String getPartialName(String originalName) {
        if (Pattern.compile("/").matcher(originalName).find()) {
            String[] l = originalName.split("/", 0);
            int n = l.length;
            if (n == 1) {
                return l[0];
            }
            return "..." + l[n - 2] + "/" + l[n - 1];
        }
        if (Pattern.compile("\\\\").matcher(originalName).find()) {
            String[] l = originalName.split("\\\\", 0);
            int n = l.length;
            if (n == 1) {
                return l[0];
            }
            return "..." + l[n - 2] + "\\" + l[n - 1];
        }
        return originalName;
    }

    protected ImageDisplay(String title, String note, Object hierarchyObject) {
        super(title, note);
        if (hierarchyObject == null) {
            throw new NullPointerException("No hierarchy object.");
        }
        this.hierarchyObject = hierarchyObject;
        this.childrenDisplay = new HashSet();
    }

    public void fireAnnotation() {
        if (this.hierarchyObject instanceof ImageData || this.hierarchyObject instanceof DatasetData) {
            this.firePropertyChange(ANNOTATE_NODE_PROPERTY, null, this);
        }
    }

    public ImageDisplay getParentDisplay() {
        return this.parentDisplay;
    }

    public Set getChildrenDisplay() {
        return Collections.unmodifiableSet(this.childrenDisplay);
    }

    public void addChildDisplay(ImageDisplay child) {
        if (child == null) {
            throw new NullPointerException("No child.");
        }
        if (this.childrenDisplay.contains(child)) {
            return;
        }
        if (child.parentDisplay != null) {
            child.parentDisplay.removeChildDisplay(child);
        }
        child.parentDisplay = this;
        this.childrenDisplay.add(child);
        this.getInternalDesktop().add(child);
    }

    public void removeChildDisplay(ImageDisplay child) {
        if (child == null) {
            throw new NullPointerException("No child.");
        }
        if (this.childrenDisplay.contains(child)) {
            child.parentDisplay.childrenDisplay.remove(child);
            child.parentDisplay.getInternalDesktop().remove(child);
            child.parentDisplay = null;
        }
    }

    public void removeAllChildrenDisplay() {
        Iterator i = this.childrenDisplay.iterator();
        HashSet toRemove = new HashSet(this.childrenDisplay.size());
        while (i.hasNext()) {
            toRemove.add(i.next());
        }
        i = toRemove.iterator();
        while (i.hasNext()) {
            this.removeChildDisplay((ImageDisplay)i.next());
        }
    }

    public void setHierarchyObject(Object ho) {
        if (ho == null) {
            throw new NullPointerException("No hierarchy object.");
        }
        this.hierarchyObject = ho;
    }

    public Object getHierarchyObject() {
        return this.hierarchyObject;
    }

    public boolean isAnnotated() {
        if (this.hierarchyObject instanceof DatasetData) {
            DatasetData d = (DatasetData)this.hierarchyObject;
            Long n = d.getAnnotationCount();
            return n != null && n > 0L;
        }
        if (this.hierarchyObject instanceof ImageData) {
            ImageData d = (ImageData)this.hierarchyObject;
            Long n = d.getAnnotationCount();
            return n != null && n > 0L;
        }
        return false;
    }

    public void accept(ImageDisplayVisitor visitor) {
        if (visitor == null) {
            throw new NullPointerException("No visitor.");
        }
        this.accept(visitor, 2);
    }

    public void accept(ImageDisplayVisitor visitor, int algoType) {
        if (visitor == null) {
            throw new NullPointerException("No visitor.");
        }
        if (!this.checkAlgoType(algoType)) {
            throw new IllegalArgumentException("Algorithm not supported.");
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Iterator i = this.childrenDisplay.iterator();
        switch (algoType) {
            case 0: {
                while (i.hasNext()) {
                    ImageDisplay child = (ImageDisplay)i.next();
                    child.accept(visitor, algoType);
                }
                if (!(this instanceof ImageNode)) break;
                this.doAccept(visitor);
                break;
            }
            case 1: {
                while (i.hasNext()) {
                    ImageDisplay child = (ImageDisplay)i.next();
                    if (!(child instanceof ImageSet)) continue;
                    child.accept(visitor, algoType);
                }
                if (!(this instanceof ImageSet)) break;
                this.doAccept(visitor);
                break;
            }
            case 2: {
                while (i.hasNext()) {
                    ImageDisplay child = (ImageDisplay)i.next();
                    child.accept(visitor, algoType);
                }
                this.doAccept(visitor);
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public String toString() {
        String s = "";
        if (this.hierarchyObject instanceof ProjectData) {
            s = ((ProjectData)this.hierarchyObject).getName();
        } else if (this.hierarchyObject instanceof DatasetData) {
            s = ((DatasetData)this.hierarchyObject).getName();
        } else if (this.hierarchyObject instanceof ImageData) {
            s = this.getPartialName(((ImageData)this.hierarchyObject).getName());
        } else if (this.hierarchyObject instanceof CategoryData) {
            s = ((CategoryData)this.hierarchyObject).getName();
        } else if (this.hierarchyObject instanceof CategoryGroupData) {
            s = ((CategoryGroupData)this.hierarchyObject).getName();
        }
        return s;
    }

    public final boolean equals(Object x) {
        return this == x;
    }

    protected abstract void doAccept(ImageDisplayVisitor var1);

    public abstract boolean containsImages();
}

