/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.browser;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;

public class ClassifiedButton
extends JButton {
    private final String DESCRIPTION = "Categorised image.";
    private final String DESCRIPTION_FULL = "Categorised image. Click to display the categorization. ";
    private final ImageNode parentNode;

    public ClassifiedButton(ImageNode node, boolean withListener) {
        if (node == null) {
            throw new IllegalArgumentException("No node");
        }
        this.parentNode = node;
        this.setContentAreaFilled(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setOpaque(false);
        this.setFocusPainted(false);
        IconManager im = IconManager.getInstance();
        this.setIcon(im.getIcon(47));
        if (withListener) {
            this.setToolTipText("Categorised image. Click to display the categorization. ");
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClassifiedButton.this.parentNode.fireClassification();
                }
            });
        } else {
            this.setToolTipText("Categorised image.");
        }
    }

    ClassifiedButton(ImageNode node) {
        this(node, true);
    }
}

