/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.browser;

import java.awt.Cursor;
import java.awt.Point;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageFinder;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageSet;
import org.openmicroscopy.shoola.agents.hiviewer.browser.RootDisplay;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BrowserModel
extends AbstractComponent
implements Browser {
    private boolean mouseOver;
    private boolean rollOver;
    private boolean thumbSelected;
    private Point popupPoint;
    private RootDisplay rootDisplay;
    private int selectedLayout;
    private boolean multiSelection;
    private Set<ImageDisplay> selectedDisplays;
    private boolean titleBarVisible;
    private ImageDisplay rollOverNode;

    private void addToDesktop(ImageDisplay node) {
        if (node instanceof ImageNode) {
            return;
        }
        JComponent desktop = node.getInternalDesktop();
        Set children = node.getChildrenDisplay();
        if (children == null) {
            return;
        }
        for (ImageDisplay child : children) {
            if (!node.containsImages()) {
                this.addToDesktop(child);
                continue;
            }
            desktop.add(child);
        }
    }

    BrowserModel(RootDisplay view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.rootDisplay = view;
        this.selectedDisplays = new HashSet<ImageDisplay>();
        this.titleBarVisible = true;
    }

    void setSelectedDisplay(ImageDisplay node, boolean multiSelection) {
        this.thumbSelected = false;
        this.popupPoint = null;
        this.multiSelection = multiSelection;
        HashSet<ImageDisplay> oldValue = new HashSet<ImageDisplay>(this.selectedDisplays.size());
        Iterator<ImageDisplay> i = this.selectedDisplays.iterator();
        while (i.hasNext()) {
            oldValue.add(i.next());
        }
        if (!multiSelection) {
            this.selectedDisplays.removeAll(this.selectedDisplays);
        }
        if (node != null) {
            this.selectedDisplays.add(node);
        }
        this.firePropertyChange("selectedDisplay", oldValue, node);
    }

    String currentPathString(ImageDisplay parent) {
        StringBuffer buf = new StringBuffer();
        while (parent != null && !(parent instanceof RootDisplay)) {
            String title = parent.getTitle();
            if (title == null || title.length() == 0) {
                title = "[..]";
            }
            if (parent instanceof ImageSet) {
                buf.insert(0, " > ");
            }
            buf.insert(0, title);
            parent = parent.getParentDisplay();
        }
        return buf.toString();
    }

    void setNodeForProperty(String propName, Object node) {
        this.firePropertyChange(propName, null, node);
    }

    void setRollOverNode(ImageNode newNode) {
        ImageDisplay previousNode = this.rollOverNode;
        this.rollOverNode = newNode;
        this.firePropertyChange("rollOver", previousNode, newNode);
    }

    @Override
    public Set getRootNodes() {
        return this.rootDisplay.getChildrenDisplay();
    }

    @Override
    public Set getSelectedDisplays() {
        return this.selectedDisplays;
    }

    @Override
    public void setSelectedDisplay(ImageDisplay node) {
        this.setSelectedDisplay(node, false);
    }

    @Override
    public void setSelectedDisplays(ImageDisplay[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            this.setSelectedDisplay(nodes[i], true);
        }
    }

    @Override
    public ImageDisplay getLastSelectedDisplay() {
        Iterator<ImageDisplay> i = this.selectedDisplays.iterator();
        int index = 0;
        while (i.hasNext()) {
            if (index == this.selectedDisplays.size() - 1) {
                return i.next();
            }
            ++index;
        }
        return null;
    }

    @Override
    public void setThumbSelected(boolean selected, ImageNode node) {
        if (node == null) {
            throw new IllegalArgumentException("No node");
        }
        if (!selected) {
            return;
        }
        this.popupPoint = null;
        this.thumbSelected = selected;
        this.firePropertyChange("thumbSelected", null, node);
    }

    @Override
    public boolean isThumbSelected() {
        return this.thumbSelected;
    }

    @Override
    public void setPopupPoint(Point p) {
        this.thumbSelected = false;
        Point oldValue = this.popupPoint;
        this.popupPoint = p;
        this.firePropertyChange("popupPoint", oldValue, p);
    }

    @Override
    public Point getPopupPoint() {
        return this.popupPoint;
    }

    @Override
    public Set<ImageData> getImages() {
        ImageFinder finder = new ImageFinder();
        this.accept(finder, 0);
        return finder.getImages();
    }

    @Override
    public Set getImageNodes() {
        ImageFinder finder = new ImageFinder();
        this.accept(finder, 0);
        return finder.getImageNodes();
    }

    @Override
    public void accept(ImageDisplayVisitor visitor) {
        this.rootDisplay.accept(visitor, 2);
    }

    @Override
    public void accept(ImageDisplayVisitor visitor, int algoType) {
        this.rootDisplay.accept(visitor, algoType);
    }

    @Override
    public JComponent getUI() {
        return this.rootDisplay;
    }

    @Override
    public void setSelectedLayout(int index) {
        int oldIndex = this.selectedLayout;
        switch (index) {
            case 1: 
            case 2: {
                this.selectedLayout = index;
                break;
            }
            default: {
                this.selectedLayout = 1;
            }
        }
        this.firePropertyChange("layout", new Integer(oldIndex), new Integer(this.selectedLayout));
    }

    @Override
    public int getSelectedLayout() {
        return this.selectedLayout;
    }

    @Override
    public boolean isMultiSelection() {
        return this.multiSelection;
    }

    @Override
    public boolean isTitleBarVisible() {
        return this.titleBarVisible;
    }

    @Override
    public void setTitleBarVisible(boolean b) {
        this.titleBarVisible = b;
    }

    @Override
    public void setRollOver(boolean rollOver) {
        this.setRollOverNode(null);
        this.rollOver = rollOver;
    }

    @Override
    public boolean isRollOver() {
        return this.rollOver;
    }

    @Override
    public boolean isMouseOver() {
        return this.mouseOver;
    }

    @Override
    public void setMouseOver(boolean b) {
        this.mouseOver = b;
    }

    @Override
    public void resetChildDisplay() {
        this.rootDisplay.setCursor(Cursor.getPredefinedCursor(3));
        Set rootChildren = this.rootDisplay.getChildrenDisplay();
        JComponent desktop = this.rootDisplay.getInternalDesktop();
        desktop.removeAll();
        if (this.selectedLayout == 1) {
            for (ImageDisplay child : rootChildren) {
                desktop.add(child);
                this.addToDesktop(child);
            }
        } else if (this.selectedLayout == 2) {
            Iterator i = this.getImageNodes().iterator();
            while (i.hasNext()) {
                desktop.add((ImageDisplay)i.next());
            }
        }
        this.rootDisplay.setCursor(Cursor.getPredefinedCursor(0));
    }
}

