/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.browser;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.agents.hiviewer.Colors;
import org.openmicroscopy.shoola.agents.hiviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageSet;
import org.openmicroscopy.shoola.agents.hiviewer.browser.RootDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ViewCmd;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ImageData;

class BrowserControl
implements MouseListener,
ImageDisplayVisitor,
PropertyChangeListener {
    private BrowserModel model;
    private RootDisplay view;
    private boolean popupTrigger;

    private ImageDisplay findParentDisplay(Object x) {
        while (true) {
            if (x instanceof ImageDisplay) {
                return (ImageDisplay)x;
            }
            if (!(x instanceof JComponent)) break;
            x = ((JComponent)x).getParent();
        }
        return null;
    }

    BrowserControl(BrowserModel model, RootDisplay view) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        model.addPropertyChangeListener("selectedDisplay", this);
        model.addPropertyChangeListener("rollOver", this);
        this.model = model;
        this.view = view;
        this.popupTrigger = false;
    }

    void initialize() {
        this.model.accept(this);
    }

    public void visit(ImageNode node) {
        node.addMouseListenerToComponents(this);
        node.addPropertyChangeListener("classifyNode", this);
        node.addPropertyChangeListener("pinThumbnail", this);
        node.addPropertyChangeListener("annotateNode", this);
    }

    public void visit(ImageSet node) {
        node.getTitleBar().addMouseListener(this);
        node.getInternalDesktop().addMouseListener(this);
        node.addPropertyChangeListener("endMoving", this);
        if (node.getHierarchyObject() instanceof DatasetData) {
            node.addPropertyChangeListener("annotateNode", this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("classifyNode".equals(name)) {
            this.model.setNodeForProperty("classifiedNode", evt.getNewValue());
        } else if ("annotateNode".equals(name)) {
            this.model.setNodeForProperty("annotatedNode", evt.getNewValue());
        } else if ("rollOver".equals(name)) {
            ImageDisplay newNode = (ImageDisplay)evt.getNewValue();
            this.view.setTitle(this.model.currentPathString(newNode));
        } else if ("selectedDisplay".equals(name)) {
            ImageDisplay newNode = (ImageDisplay)evt.getNewValue();
            if (newNode == null) {
                return;
            }
            this.view.setTitle(this.model.currentPathString(newNode));
            Colors colors = Colors.getInstance();
            newNode.setHighlight(colors.getSelectedHighLight(newNode));
            Set nodes = (Set)evt.getOldValue();
            if (nodes != null && !this.model.isMultiSelection()) {
                for (ImageDisplay n : nodes) {
                    if (n == null) continue;
                    n.setHighlight(colors.getDeselectedHighLight(n));
                }
            }
        } else if ("pinThumbnail".equals(name)) {
            ImageNode node = (ImageNode)evt.getNewValue();
            this.model.setThumbSelected(true, node);
        } else if ("endMoving".equals(name)) {
            // empty if block
        }
    }

    public void mousePressed(MouseEvent me) {
        ImageDisplay d = this.findParentDisplay(me.getSource());
        d.moveToFront();
        ImageDisplay previousDisplay = this.model.getLastSelectedDisplay();
        boolean b = me.isShiftDown();
        if (!d.equals(previousDisplay)) {
            if (d instanceof ImageNode) {
                if (!(previousDisplay instanceof ImageNode)) {
                    b = false;
                }
                this.model.setSelectedDisplay(d, b);
            } else {
                this.model.setSelectedDisplay(d);
            }
        }
        if (me.isPopupTrigger()) {
            this.popupTrigger = true;
        }
    }

    public void mouseReleased(MouseEvent me) {
        if (this.popupTrigger || me.isPopupTrigger()) {
            this.model.setPopupPoint(me.getPoint());
        } else {
            Object src = me.getSource();
            ImageDisplay d = this.findParentDisplay(src);
            if (d instanceof ImageNode && d.getTitleBar() != src && me.getClickCount() == 2) {
                ViewCmd cmd = new ViewCmd((DataObject)((ImageData)d.getHierarchyObject()));
                cmd.execute();
            }
        }
        this.popupTrigger = false;
    }

    public void mouseEntered(MouseEvent me) {
        boolean mo = this.model.isMouseOver();
        boolean ro = this.model.isRollOver();
        if (!mo && !ro) {
            return;
        }
        Object src = me.getSource();
        ImageDisplay d = this.findParentDisplay(src);
        if (mo) {
            if (d instanceof RootDisplay) {
                ImageDisplay lastSelected = this.model.getLastSelectedDisplay();
                if (lastSelected != null) {
                    this.view.setTitle(this.model.currentPathString(lastSelected));
                } else {
                    lastSelected = null;
                }
                this.model.setNodeForProperty("mouseOver", lastSelected);
                return;
            }
            if (!(d instanceof RootDisplay)) {
                this.view.setTitle(this.model.currentPathString(d));
            }
            this.model.setNodeForProperty("mouseOver", d);
        }
        if (!ro) {
            return;
        }
        if (d instanceof ImageNode && d.getTitleBar() != src) {
            this.model.setRollOverNode((ImageNode)d);
        } else {
            this.model.setRollOverNode(null);
        }
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mouseClicked(MouseEvent me) {
    }
}

