/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.browser;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;

public class AnnotatedButton
extends JButton {
    private final String DESCRIPTION = "Annotated object.";
    private final String DESCRIPTION_FULL = "Annotated object. Click to view the annotation. ";
    private final ImageNode parentNode;

    public AnnotatedButton(ImageNode node, boolean withListener) {
        if (node == null) {
            throw new IllegalArgumentException("No node");
        }
        this.parentNode = node;
        this.setContentAreaFilled(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setOpaque(false);
        this.setFocusPainted(false);
        IconManager im = IconManager.getInstance();
        this.setIcon(im.getIcon(45));
        if (withListener) {
            this.setToolTipText("Annotated object. Click to view the annotation. ");
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AnnotatedButton.this.parentNode.fireAnnotation();
                }
            });
        } else {
            this.setToolTipText("Annotated object.");
        }
    }

    AnnotatedButton(ImageNode node) {
        this(node, true);
    }
}

