/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.actions.HiViewerAction;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ZoomCmd;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ImageData;

public class ZoomOutAction
extends HiViewerAction {
    public static final String NAME = "Zoom out";
    private static final String DESCRIPTION = "Zoom out all images within the selected container.";

    protected void onStateChange() {
        int layout = this.model.getBrowser().getSelectedLayout();
        this.setEnabled(layout == 2);
    }

    protected void onDisplayChange(ImageDisplay selectedDisplay) {
        int layout = this.model.getBrowser().getSelectedLayout();
        if (layout == 2) {
            this.setEnabled(true);
            return;
        }
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        if (selectedDisplay.getParentDisplay() == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(!(selectedDisplay.getHierarchyObject() instanceof ImageData));
        }
    }

    public ZoomOutAction(HiViewer model) {
        super(model);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(10));
    }

    public void actionPerformed(ActionEvent e) {
        ZoomCmd cmd = new ZoomCmd(this.model, 1);
        cmd.execute();
    }
}

